/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.utils;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import tfar.dankstorage.DankItemBlock;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.block.DankBlock;
import tfar.dankstorage.container.AbstractAbstractDankContainer;
import tfar.dankstorage.inventory.DankHandler;
import tfar.dankstorage.inventory.PortableDankHandler;
import tfar.dankstorage.network.CMessageTogglePickup;
import tfar.dankstorage.network.CMessageToggleUseType;
import tfar.dankstorage.utils.SortingData;

public class Utils {
    public static final Tag<Item> BLACKLISTED_STORAGE = new ItemTags.Wrapper(new ResourceLocation("dankstorage", "blacklisted_storage"));
    public static final Tag<Item> BLACKLISTED_USAGE = new ItemTags.Wrapper(new ResourceLocation("dankstorage", "blacklisted_usage"));
    public static final Tag<Item> WRENCHES = new ItemTags.Wrapper(new ResourceLocation("forge", "wrenches"));
    public static final String INV = "inv";
    public static final Set<ResourceLocation> taglist = new HashSet<ResourceLocation>();
    public static boolean DEV;

    public static CMessageTogglePickup.Mode getMode(ItemStack bag) {
        return CMessageTogglePickup.modes[bag.func_196082_o().func_74762_e("mode")];
    }

    public static boolean isConstruction(ItemStack bag) {
        return bag.func_77973_b() instanceof DankItemBlock && bag.func_77942_o() && bag.func_77978_p().func_74764_b("construction") && bag.func_77978_p().func_74762_e("construction") == 2;
    }

    public static void cycleMode(ItemStack bag, PlayerEntity player) {
        int ordinal = bag.func_196082_o().func_74762_e("mode");
        if (++ordinal > 3) {
            ordinal = 0;
        }
        bag.func_196082_o().func_74768_a("mode", ordinal);
        player.func_146105_b((ITextComponent)new TranslationTextComponent("dankstorage.mode." + CMessageTogglePickup.modes[ordinal].name(), new Object[0]), true);
    }

    public static CMessageToggleUseType.UseType getUseType(ItemStack bag) {
        return CMessageToggleUseType.useTypes[bag.func_196082_o().func_74762_e("construction")];
    }

    public static void cyclePlacement(ItemStack bag, PlayerEntity player) {
        int ordinal = bag.func_196082_o().func_74762_e("construction");
        if (++ordinal >= CMessageToggleUseType.useTypes.length) {
            ordinal = 0;
        }
        bag.func_196082_o().func_74768_a("construction", ordinal);
        player.func_146105_b((ITextComponent)new TranslationTextComponent("dankstorage.usetype." + CMessageToggleUseType.useTypes[ordinal].name(), new Object[0]), true);
    }

    public static int getSelectedSlot(ItemStack bag) {
        return bag.func_196082_o().func_74762_e("selectedSlot");
    }

    public static void setSelectedSlot(ItemStack bag, int slot) {
        bag.func_196082_o().func_74768_a("selectedSlot", slot);
    }

    public static int getSlotCount(ItemStack bag) {
        return Utils.getSlotCount(Utils.getTier(bag));
    }

    public static int getSlotCount(int tier) {
        if (tier > 0 && tier < 7) {
            return 9 * tier;
        }
        if (tier == 7) {
            return 81;
        }
        throw new IndexOutOfBoundsException("tier " + tier + " is out of bounds!");
    }

    public static void sort(PlayerEntity player) {
        if (player == null) {
            return;
        }
        Container openContainer = player.field_71070_bA;
        if (openContainer instanceof AbstractAbstractDankContainer) {
            ArrayList<SortingData> itemlist = new ArrayList<SortingData>();
            DankHandler handler = ((AbstractAbstractDankContainer)openContainer).getHandler();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                boolean exists = SortingData.exists(itemlist, stack.func_77946_l());
                if (exists) {
                    int rem = SortingData.addToList(itemlist, stack.func_77946_l());
                    if (rem <= 0) continue;
                    ItemStack bigstack = stack.func_77946_l();
                    bigstack.func_190920_e(Integer.MAX_VALUE);
                    ItemStack smallstack = stack.func_77946_l();
                    smallstack.func_190920_e(rem);
                    itemlist.add(new SortingData(bigstack));
                    itemlist.add(new SortingData(smallstack));
                    continue;
                }
                itemlist.add(new SortingData(stack.func_77946_l()));
            }
            handler.getContents().clear();
            Collections.sort(itemlist);
            for (SortingData data : itemlist) {
                ItemStack stack = data.stack.func_77946_l();
                ItemStack rem = stack.func_77946_l();
                for (int i = 0; i < handler.getSlots() && !(rem = handler.insertItem(i, rem, false)).func_190926_b(); ++i) {
                }
            }
        }
    }

    public static int getStackLimit(ItemStack bag) {
        return Utils.getStackLimit(bag.func_77973_b().getRegistryName());
    }

    public static int getStackLimit(ResourceLocation registryname) {
        switch (Utils.getTier(registryname)) {
            default: {
                return (Integer)DankStorage.ServerConfig.stacklimit1.get();
            }
            case 2: {
                return (Integer)DankStorage.ServerConfig.stacklimit2.get();
            }
            case 3: {
                return (Integer)DankStorage.ServerConfig.stacklimit3.get();
            }
            case 4: {
                return (Integer)DankStorage.ServerConfig.stacklimit4.get();
            }
            case 5: {
                return (Integer)DankStorage.ServerConfig.stacklimit5.get();
            }
            case 6: {
                return (Integer)DankStorage.ServerConfig.stacklimit6.get();
            }
            case 7: 
        }
        return (Integer)DankStorage.ServerConfig.stacklimit7.get();
    }

    public static int getTier(ItemStack bag) {
        return Utils.getTier(bag.func_77973_b().getRegistryName());
    }

    public static int getTier(ResourceLocation registryname) {
        return Integer.parseInt(registryname.func_110623_a().substring(5));
    }

    public static void changeSlot(ItemStack bag, boolean right) {
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            DankHandler dankHandler = (DankHandler)((Object)handler);
            if (dankHandler.noValidSlots()) {
                return;
            }
            int selectedSlot = Utils.getSelectedSlot(bag);
            int size = handler.getSlots();
            do {
                if (right) {
                    if (++selectedSlot < size) continue;
                    selectedSlot = 0;
                    continue;
                }
                if (--selectedSlot >= 0) continue;
                selectedSlot = size - 1;
            } while (handler.getStackInSlot(selectedSlot).func_190926_b() || handler.getStackInSlot(selectedSlot).func_77973_b().func_206844_a(BLACKLISTED_USAGE));
            Utils.setSelectedSlot(bag, selectedSlot);
        });
    }

    public static boolean oredict(ItemStack bag) {
        return bag.func_77973_b() instanceof DankItemBlock && bag.func_77942_o() && bag.func_77978_p().func_74767_n("tag");
    }

    public static PortableDankHandler getHandler(ItemStack bag) {
        return new PortableDankHandler(bag);
    }

    public static int getNbtSize(ItemStack stack) {
        return Utils.getNbtSize(stack.func_77978_p());
    }

    public static DankBlock getBlockFromTier(int tier) {
        return (DankBlock)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("dankstorage", "dank_" + tier));
    }

    public static int getNbtSize(@Nullable CompoundNBT nbt) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150786_a(nbt);
        buffer.release();
        return buffer.writerIndex();
    }

    public static ItemStack getItemStackInSelectedSlot(ItemStack bag) {
        return (ItemStack)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
            ItemStack stack = iItemHandler.getStackInSlot(Utils.getSelectedSlot(bag));
            return stack.func_77973_b().func_206844_a(BLACKLISTED_USAGE) ? ItemStack.field_190927_a : stack;
        }).orElse((Object)ItemStack.field_190927_a);
    }

    public static boolean areItemStacksConvertible(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77942_o() || stack2.func_77942_o()) {
            return false;
        }
        Set taglistofstack1 = stack1.func_77973_b().getTags();
        Set taglistofstack2 = stack2.func_77973_b().getTags();
        HashSet commontags = new HashSet(taglistofstack1);
        commontags.retainAll(taglistofstack2);
        commontags.retainAll(taglist);
        return !commontags.isEmpty();
    }

    @Nullable
    public static CompoundNBT copyNBTSkipKey(@Nonnull CompoundNBT nbt, @Nonnull String keyToSkip) {
        CompoundNBT copiedNBT = new CompoundNBT();
        for (String key : nbt.func_150296_c()) {
            INBT innerNBT;
            if (keyToSkip.equals(key) || (innerNBT = nbt.func_74781_a(key)) == null) continue;
            copiedNBT.func_218657_a(key, innerNBT.func_74737_b());
        }
        if (copiedNBT.isEmpty()) {
            return null;
        }
        return copiedNBT;
    }

    public static boolean isMixinInClasspath() {
        try {
            Class.forName("org.spongepowered.asm.launch.Phases");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        try {
            Items.class.getField("field_190931_a");
            DEV = false;
        }
        catch (NoSuchFieldException e) {
            DEV = true;
        }
    }
}

