/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network;

import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.dankstorage.DankItemBlock;
import tfar.dankstorage.inventory.PortableDankHandler;
import tfar.dankstorage.utils.Utils;

public class CMessagePickBlock {
    private static final Logger LOGGER = LogManager.getLogger();

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        ctx.get().enqueueWork(() -> CMessagePickBlock.lambda$handle$0((PlayerEntity)player));
        ctx.get().setPacketHandled(true);
    }

    public static ItemStack onPickBlock(RayTraceResult target, PlayerEntity player, World world) {
        ItemStack result = ItemStack.field_190927_a;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
            BlockState state = world.func_180495_p(pos);
            if (state.isAir((IBlockReader)world, pos)) {
                return ItemStack.field_190927_a;
            }
            result = state.func_177230_c().getPickBlock(state, target, (IBlockReader)world, pos, player);
            if (result.func_190926_b()) {
                LOGGER.warn("Picking on: [{}] {} gave null item", (Object)target.func_216346_c(), (Object)state.func_177230_c().getRegistryName());
            }
        }
        return result;
    }

    private static /* synthetic */ void lambda$handle$0(PlayerEntity player) {
        ItemStack bag = player.func_184614_ca();
        if (bag.func_77973_b() instanceof DankItemBlock) {
            PortableDankHandler handler = Utils.getHandler(bag);
            ItemStack pickblock = CMessagePickBlock.onPickBlock(Minecraft.func_71410_x().field_71476_x, player, player.field_70170_p);
            int slot = -1;
            if (!pickblock.func_190926_b()) {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (pickblock.func_77973_b() != handler.getStackInSlot(i).func_77973_b()) continue;
                    slot = i;
                    break;
                }
            }
            if (slot != -1) {
                Utils.setSelectedSlot(bag, slot);
            }
        }
    }
}

