/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import tfar.dankstorage.block.DankBlock;
import tfar.dankstorage.item.UpgradeInfo;
import tfar.dankstorage.tile.AbstractDankStorageTile;
import tfar.dankstorage.utils.Utils;

public class UpgradeItem
extends Item {
    protected final UpgradeInfo upgradeInfo;

    public UpgradeItem(Item.Properties properties, UpgradeInfo info) {
        super(properties);
        this.upgradeInfo = info;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        ItemStack upgradeStack = context.func_195996_i();
        BlockState state = world.func_180495_p(pos);
        if (player == null || !(state.func_177230_c() instanceof DankBlock) || !this.upgradeInfo.canUpgrade((DankBlock)state.func_177230_c())) {
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        TileEntity oldDank = world.func_175625_s(pos);
        ArrayList<ItemStack> oldDankContents = new ArrayList<ItemStack>((Collection<ItemStack>)((AbstractDankStorageTile)oldDank).getHandler().getContents());
        oldDank.func_145843_s();
        DankBlock newBlock = Utils.getBlockFromTier(this.upgradeInfo.end);
        BlockState newState = newBlock.func_176223_P();
        world.func_180501_a(pos, newState, 3);
        TileEntity newBarrel = world.func_175625_s(pos);
        newBarrel.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> IntStream.range(0, oldDankContents.size()).forEach(i -> itemHandler.insertItem(i, (ItemStack)oldDankContents.get(i), false)));
        if (!player.field_71075_bZ.field_75098_d) {
            upgradeStack.func_190918_g(1);
        }
        player.func_146105_b(new TranslationTextComponent("metalbarrels.upgrade_successful", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), true);
        return ActionResultType.SUCCESS;
    }
}

