/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import org.cyclops.cyclopscore.nbt.path.NbtParseException;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public interface INbtPathExpression {
    default public NbtPathExpressionMatches match(Stream<INBT> nbts) {
        return this.matchContexts(nbts.map(NbtPathExpressionExecutionContext::new));
    }

    default public NbtPathExpressionMatches match(INBT nbt) {
        return this.match(Stream.of(nbt));
    }

    default public boolean test(Stream<INBT> nbts) {
        return this.match(nbts.limit(1L)).getMatches().findAny().filter(tag -> tag.func_74732_a() != 1 || ((ByteNBT)tag).func_150290_f() == 1).isPresent();
    }

    default public boolean test(INBT nbt) {
        return this.test(Stream.of(nbt));
    }

    public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> var1);

    default public INbtPathNavigation asNavigation(@Nullable INbtPathNavigation child) throws NbtParseException {
        throw new NbtParseException("This NBT Path expression has no navigation keys.");
    }

    default public INbtPathNavigation asNavigation() throws NbtParseException {
        return this.asNavigation(null);
    }
}

