/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.fluid.EmptyFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeSerializerHelpers {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static Ingredient getJsonIngredient(JsonObject json, String key, boolean required) {
        JsonElement element = json.get(key);
        if (element == null) {
            if (required) {
                throw new JsonSyntaxException("Missing " + key + ", expected to find an ingredient object or string value");
            }
            return Ingredient.field_193370_a;
        }
        if (element.isJsonObject()) {
            return Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)key));
        }
        if (element.isJsonArray()) {
            return Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)key));
        }
        String itemName = JSONUtils.func_151200_h((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = new ResourceLocation(itemName);
        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Registry.field_212630_s.func_218349_b(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Item: " + itemName + " does not exist")))});
    }

    public static ItemStack getJsonItemStackOrTag(JsonObject json, boolean required) {
        if (json.has("tag")) {
            return RecipeSerializerHelpers.getJsonItemStackFromTag(json, "tag");
        }
        return RecipeSerializerHelpers.getJsonItemStack(json, "item", required);
    }

    public static ItemStack getJsonItemStack(JsonObject json, String key, boolean required) {
        JsonElement element = json.get(key);
        if (element == null) {
            if (required) {
                throw new JsonSyntaxException("Missing " + key + ", expected to find an item object or string value");
            }
            return ItemStack.field_190927_a;
        }
        if (element.isJsonObject()) {
            return ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)key));
        }
        String itemName = JSONUtils.func_151200_h((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = new ResourceLocation(itemName);
        return new ItemStack((IItemProvider)Registry.field_212630_s.func_218349_b(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Item: " + itemName + " does not exist")));
    }

    public static ItemStack getJsonItemStackFromTag(JsonObject json, String key) {
        ItemStack[] matchingStacks = Ingredient.func_199802_a((JsonElement)json).func_193365_a();
        if (matchingStacks.length == 0) {
            throw new IllegalStateException("No tag value found for " + key + " does not exist");
        }
        int count = 1;
        if (json.has("count")) {
            count = json.get("count").getAsInt();
        }
        matchingStacks[0].func_190920_e(count);
        return matchingStacks[0];
    }

    public static FluidStack deserializeFluidStack(JsonObject json, boolean readNbt) {
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        String fluidName = JSONUtils.func_151200_h((JsonObject)json, (String)"fluid");
        ResourceLocation resourcelocation = new ResourceLocation(fluidName);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourcelocation);
        if (fluid instanceof EmptyFluid) {
            throw new JsonParseException("Unknown fluid '" + fluidName + "'");
        }
        CompoundNBT tag = null;
        if (readNbt && json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                tag = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        int amount = 1000;
        if (json.has("amount")) {
            amount = JSONUtils.func_151203_m((JsonObject)json, (String)"amount");
        }
        return new FluidStack(fluid, amount, tag);
    }

    public static FluidStack getJsonFluidStack(JsonObject json, String key, boolean required) {
        JsonElement element = json.get(key);
        if (element == null) {
            if (required) {
                throw new JsonSyntaxException("Missing " + key + ", expected to find a fluid object or string value");
            }
            return FluidStack.EMPTY;
        }
        if (element.isJsonObject()) {
            return RecipeSerializerHelpers.deserializeFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)key), true);
        }
        String fluidName = JSONUtils.func_151200_h((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = new ResourceLocation(fluidName);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourcelocation);
        if (fluid instanceof EmptyFluid) {
            throw new JsonParseException("Unknown fluid '" + fluidName + "'");
        }
        return new FluidStack(fluid, 1000);
    }
}

