/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.resources.IResource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public final class ModelHelpers {
    public static final ItemTransformVec3f THIRD_PERSON_RIGHT_HAND = new ItemTransformVec3f(new Vector3f(70.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f));
    public static final ItemTransformVec3f THIRD_PERSON_LEFT_HAND = new ItemTransformVec3f(new Vector3f(70.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f));
    public static final ItemTransformVec3f FIRST_PERSON_RIGHT_HAND = new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f));
    public static final ItemTransformVec3f FIRST_PERSON_LEFT_HAND = new ItemTransformVec3f(new Vector3f(0.0f, 255.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f));
    public static final ItemTransformVec3f HEAD = ItemTransformVec3f.field_178366_a;
    public static final ItemTransformVec3f GROUND = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f));
    public static final ItemTransformVec3f FIXED = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f));
    public static final ItemTransformVec3f GUI = new ItemTransformVec3f(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f));
    public static final ItemCameraTransforms DEFAULT_CAMERA_TRANSFORMS = new ItemCameraTransforms(THIRD_PERSON_RIGHT_HAND, THIRD_PERSON_LEFT_HAND, FIRST_PERSON_RIGHT_HAND, FIRST_PERSON_LEFT_HAND, HEAD, GUI, GROUND, FIXED);
    public static final ItemTransformVec3f THIRD_PERSON_RIGHT_HAND_ITEM = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.55f, 0.55f, 0.55f));
    public static final ItemTransformVec3f THIRD_PERSON_LEFT_HAND_ITEM = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.55f, 0.55f, 0.55f));
    public static final ItemTransformVec3f FIRST_PERSON_RIGHT_HAND_ITEM = new ItemTransformVec3f(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.68f, 0.68f, 0.68f));
    public static final ItemTransformVec3f FIRST_PERSON_LEFT_HAND_ITEM = new ItemTransformVec3f(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.68f, 0.68f, 0.68f));
    public static final ItemTransformVec3f HEAD_ITEM = ItemTransformVec3f.field_178366_a;
    public static final ItemTransformVec3f GROUND_ITEM = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f));
    public static final ItemTransformVec3f FIXED_ITEM = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
    public static final ItemTransformVec3f GUI_ITEM = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
    public static final ItemCameraTransforms DEFAULT_CAMERA_TRANSFORMS_ITEM = new ItemCameraTransforms(THIRD_PERSON_RIGHT_HAND_ITEM, THIRD_PERSON_LEFT_HAND_ITEM, FIRST_PERSON_RIGHT_HAND_ITEM, FIRST_PERSON_LEFT_HAND_ITEM, HEAD_ITEM, GUI_ITEM, GROUND_ITEM, FIXED_ITEM);
    public static final Map<Direction, List<BakedQuad>> EMPTY_FACE_QUADS = Maps.newHashMap();

    public static BlockModel loadModelBlock(ResourceLocation modelLocation) throws IOException {
        IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a() + ".json"));
        InputStreamReader reader = new InputStreamReader(resource.func_199027_b(), Charsets.UTF_8);
        return BlockModel.func_178307_a((Reader)reader);
    }

    public static <T> T getSafeProperty(@Nullable IModelData modelData, ModelProperty<T> property, T fallback) {
        Object value;
        if (modelData == null) {
            return fallback;
        }
        try {
            value = modelData.getData(property);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static ItemCameraTransforms modifyDefaultTransforms(Map<ItemCameraTransforms.TransformType, ItemTransformVec3f> overrides) {
        return new ItemCameraTransforms(overrides.getOrDefault(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, THIRD_PERSON_RIGHT_HAND), overrides.getOrDefault(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, THIRD_PERSON_LEFT_HAND), overrides.getOrDefault(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, FIRST_PERSON_RIGHT_HAND), overrides.getOrDefault(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, FIRST_PERSON_LEFT_HAND), overrides.getOrDefault(ItemCameraTransforms.TransformType.HEAD, HEAD), overrides.getOrDefault(ItemCameraTransforms.TransformType.GUI, GUI), overrides.getOrDefault(ItemCameraTransforms.TransformType.GROUND, GROUND), overrides.getOrDefault(ItemCameraTransforms.TransformType.FIXED, FIXED));
    }

    static {
        for (Direction facing : Direction.values()) {
            EMPTY_FACE_QUADS.put(facing, Collections.emptyList());
        }
    }
}

