/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LootHelpers {
    private static final LootHelpers INSTANCE = new LootHelpers();
    private static final Multimap<ResourceLocation, ResourceLocation> INJECT_LOOTTABLES = MultimapBuilder.ListMultimapBuilder.hashKeys().arrayListValues().build();

    private LootHelpers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        for (ResourceLocation injectTable : INJECT_LOOTTABLES.get((Object)event.getName())) {
            LootHelpers.injectLootTableDirect(event.getTable(), injectTable);
        }
    }

    public static void injectLootTable(ResourceLocation source, ResourceLocation ... targets) {
        LootTables.func_186375_a((ResourceLocation)source);
        for (ResourceLocation target : targets) {
            INJECT_LOOTTABLES.put((Object)target, (Object)source);
        }
    }

    public static void injectLootTableDirect(LootTable target, ResourceLocation source) {
        target.addPool(new LootPool.Builder().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)source)).name(source.toString()).func_216044_b());
    }
}

