/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;

public final class L10NHelpers {
    public static final int MAX_TOOLTIP_LINE_LENGTH = 25;
    private static final String KEY_ENABLED = "general.cyclopscore.info.enabled";
    private static final String KEY_DISABLED = "general.cyclopscore.info.disabled";

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String key, Object ... params) {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return I18n.func_135052_a((String)key, (Object[])params);
        }
        return String.format("%s: %s", key, Arrays.toString(params));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addStatusInfo(List<ITextComponent> infoLines, boolean isEnabled, String statusPrefixKey) {
        TranslationTextComponent autoSupply = new TranslationTextComponent(KEY_DISABLED, new Object[0]);
        if (isEnabled) {
            autoSupply = new TranslationTextComponent(KEY_ENABLED, new Object[0]);
        }
        infoLines.add((ITextComponent)new TranslationTextComponent(statusPrefixKey, new Object[]{autoSupply}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getLocalizedEntityName(String entityId) {
        return L10NHelpers.localize("entity." + entityId + ".name", new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addOptionalInfo(List<ITextComponent> list, String prefix) {
        String key = prefix + ".info";
        if (I18n.func_188566_a((String)key)) {
            if (MinecraftHelpers.isShifted()) {
                String localized = L10NHelpers.localize(key, new Object[0]);
                list.addAll(StringHelpers.splitLines(localized, 25, IInformationProvider.INFO_PREFIX).stream().map(StringTextComponent::new).collect(Collectors.toList()));
            } else {
                list.add(new TranslationTextComponent("general.cyclopscore.tooltip.info", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
            }
        }
    }
}

