/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class FluidConfig
extends ExtendedConfigForge<FluidConfig, Fluid> {
    public FluidConfig(ModBase mod, String namedId, Function<FluidConfig, ? extends Fluid> elementConstructor) {
        super(mod, namedId, elementConstructor);
    }

    protected static ForgeFlowingFluid.Properties getDefaultFluidProperties(ModBase mod, String texturePrefixPath, Consumer<FluidAttributes.Builder> fluidAttributesConsumer) {
        FluidAttributes.Builder fluidAttributes = FluidAttributes.builder((ResourceLocation)new ResourceLocation(mod.getModId(), texturePrefixPath + "_still"), (ResourceLocation)new ResourceLocation(mod.getModId(), texturePrefixPath + "_flow"));
        fluidAttributesConsumer.accept(fluidAttributes);
        Wrapper<ForgeFlowingFluid.Properties> properties = new Wrapper<ForgeFlowingFluid.Properties>();
        properties.set(new ForgeFlowingFluid.Properties(() -> new ForgeFlowingFluid.Source((ForgeFlowingFluid.Properties)properties.get()), () -> new ForgeFlowingFluid.Flowing((ForgeFlowingFluid.Properties)properties.get()), fluidAttributes));
        return (ForgeFlowingFluid.Properties)properties.get();
    }

    @Override
    public String getTranslationKey() {
        return "block." + this.getMod().getModId() + ".block_" + this.getNamedId();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.FLUID;
    }

    public ResourceLocation getIconLocationStill() {
        return new ResourceLocation(this.getMod().getModId(), "blocks/" + this.getNamedId() + "_still");
    }

    public ResourceLocation getIconLocationFlow() {
        return new ResourceLocation(this.getMod().getModId(), "blocks/" + this.getNamedId() + "_flow");
    }

    @Override
    @Nullable
    public IForgeRegistry<Fluid> getRegistry() {
        return ForgeRegistries.FLUIDS;
    }
}

