/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeConfigProperty;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;

public class CommandConfig
implements Command<CommandSource> {
    private final ModBase mod;
    private final boolean valueSet;

    public CommandConfig(ModBase mod, boolean valueSet) {
        this.mod = mod;
        this.valueSet = valueSet;
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ConfigurablePropertyData property = (ConfigurablePropertyData)context.getArgument("property", ConfigurablePropertyData.class);
        if (!this.valueSet) {
            ((CommandSource)context.getSource()).func_197035_h().func_145747_a((ITextComponent)new StringTextComponent(property.getConfigProperty().get().toString()));
        } else {
            String value = (String)context.getArgument("value", String.class);
            Object newValue = Helpers.tryParse(value, property.getConfigProperty().get());
            if (newValue != null) {
                property.getConfigProperty().set(newValue);
                property.getConfigProperty().save();
                ((CommandSource)context.getSource()).func_197035_h().func_145747_a((ITextComponent)new TranslationTextComponent("chat.cyclopscore.command.updatedValue", new Object[]{property.getName(), newValue.toString()}));
            } else {
                ((CommandSource)context.getSource()).func_197035_h().func_145747_a((ITextComponent)new TranslationTextComponent("chat.cyclopscore.command.invalidNewValue", new Object[0]));
                return 1;
            }
        }
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSource> make(ModBase mod) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"config").requires(commandSource -> commandSource.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"property", (ArgumentType)new ArgumentTypeConfigProperty(mod)).executes((Command)new CommandConfig(mod, false))).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.string()).executes((Command)new CommandConfig(mod, true))));
    }
}

