/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.Advancements;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacityConfig;
import org.cyclops.cyclopscore.client.particle.ParticleBlurConfig;
import org.cyclops.cyclopscore.command.CommandDebug;
import org.cyclops.cyclopscore.command.CommandDumpRegistries;
import org.cyclops.cyclopscore.command.CommandIgnite;
import org.cyclops.cyclopscore.command.CommandInfoBookTest;
import org.cyclops.cyclopscore.command.CommandReloadResources;
import org.cyclops.cyclopscore.command.argument.ArgumentSerializerMod;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeConfigProperty;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeDebugPacket;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeEnum;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoBookRegistry;
import org.cyclops.cyclopscore.infobook.test.ContainerInfoBookTestConfig;
import org.cyclops.cyclopscore.infobook.test.InfoBookTest;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.metadata.IRegistryExportableRegistry;
import org.cyclops.cyclopscore.metadata.RegistryExportableRegistry;
import org.cyclops.cyclopscore.metadata.RegistryExportables;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.modcompat.baubles.ModCompatBaubles;
import org.cyclops.cyclopscore.proxy.ClientProxy;
import org.cyclops.cyclopscore.proxy.CommonProxy;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.ImportantUsers;
import org.cyclops.cyclopscore.tracking.Versions;

@Mod(value="cyclopscore")
public class CyclopsCore
extends ModBaseVersionable<CyclopsCore> {
    public static CyclopsCore _instance;
    private boolean loaded = false;

    public CyclopsCore() {
        super("cyclopscore", instance -> {
            _instance = instance;
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        this.getRegistryManager().addRegistry(IRegistryExportableRegistry.class, RegistryExportableRegistry.getInstance());
        this.getRegistryManager().addRegistry(IInfoBookRegistry.class, new InfoBookRegistry());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    @Override
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    @Override
    protected ModCompatLoader constructModCompatLoader() {
        ModCompatLoader modCompatLoader = super.constructModCompatLoader();
        modCompatLoader.addModCompat(new ModCompatBaubles());
        return modCompatLoader;
    }

    @Override
    protected LiteralArgumentBuilder<CommandSource> constructBaseCommand() {
        LiteralArgumentBuilder<CommandSource> root = super.constructBaseCommand();
        root.then(CommandIgnite.make());
        root.then(CommandDebug.make());
        root.then(CommandReloadResources.make());
        root.then(CommandDumpRegistries.make());
        root.then(CommandInfoBookTest.make());
        return root;
    }

    @Override
    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        Advancements.load();
        RegistryExportables.load();
        ArgumentTypes.func_218136_a((String)"cyclopscore:enum", ArgumentTypeEnum.class, (IArgumentSerializer)new ArgumentTypeEnum.Serializer());
        ArgumentTypes.func_218136_a((String)"cyclopscore:config_property", ArgumentTypeConfigProperty.class, new ArgumentSerializerMod<ArgumentTypeConfigProperty>(ArgumentTypeConfigProperty::new, ArgumentTypeConfigProperty::getMod));
        ArgumentTypes.func_218136_a((String)"cyclopscore:debug_packet", ArgumentTypeDebugPacket.class, (IArgumentSerializer)new ArgumentSerializer(() -> ArgumentTypeDebugPacket.INSTANCE));
        this.getRegistryManager().getRegistry(IInfoBookRegistry.class).registerInfoBook(InfoBookTest.getInstance(), "/data/cyclopscore/info/test.xml");
    }

    @Override
    protected void onServerStarting(FMLServerStartingEvent event) {
        super.onServerStarting(event);
        Analytics.sendAll();
        Versions.checkAll();
        ImportantUsers.checkAll();
    }

    @Override
    public ItemGroup constructDefaultItemGroup() {
        return null;
    }

    @Override
    public void onConfigsRegister(ConfigHandler configHandler) {
        configHandler.addConfigurable(new GeneralConfig());
        configHandler.addConfigurable(new FluidHandlerItemCapacityConfig());
        configHandler.addConfigurable(new ParticleBlurConfig());
        configHandler.addConfigurable(new ContainerInfoBookTestConfig());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public static void clog(String message) {
        _instance.log(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.log(level, message);
    }
}

