/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.util;

import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;

public class BlockSetSelector {
    public static BlockSetSelector NORMAL = new BlockSetSelector(Blocks.field_196662_n.func_176223_P()).addBlock(Blocks.field_150347_e.func_176223_P(), 0.1f).addBlock(Blocks.field_196696_di.func_176223_P(), 0.1f).addBlock(Blocks.field_196698_dj.func_176223_P(), 0.1f).addBlock(Blocks.field_196700_dk.func_176223_P(), 0.1f).addBlock(Blocks.field_201941_jj.func_176223_P(), 0.2f);
    public static BlockSetSelector MESA = new BlockSetSelector(Blocks.field_196672_s.func_176223_P()).addBlock(Blocks.field_196719_fA.func_176223_P(), 0.05f).addBlock(Blocks.field_196778_fp.func_176223_P(), 0.05f).addBlock(Blocks.field_196783_fs.func_176223_P(), 0.05f).addBlock(Blocks.field_196777_fo.func_176223_P(), 0.05f).addBlock(Blocks.field_196696_di.func_176223_P(), 0.1f).addBlock(Blocks.field_196698_dj.func_176223_P(), 0.1f).addBlock(Blocks.field_196700_dk.func_176223_P(), 0.1f).addBlock(Blocks.field_201941_jj.func_176223_P(), 0.2f);
    public static BlockSetSelector JUNGLE = new BlockSetSelector(Blocks.field_196668_q.func_176223_P()).addBlock(Blocks.field_150341_Y.func_176223_P(), 0.1f).addBlock(Blocks.field_196696_di.func_176223_P(), 0.05f).addBlock(Blocks.field_196698_dj.func_176223_P(), 0.2f).addBlock(Blocks.field_196700_dk.func_176223_P(), 0.05f).addBlock(Blocks.field_196702_dl.func_176223_P(), 0.05f).addBlock(Blocks.field_201941_jj.func_176223_P(), 0.2f);
    public static BlockSetSelector SNOW = new BlockSetSelector(Blocks.field_196664_o.func_176223_P()).addBlock(Blocks.field_196604_cC.func_176223_P(), 0.25f).addBlock(Blocks.field_150403_cj.func_176223_P(), 0.1f).addBlock(Blocks.field_205164_gk.func_176223_P(), 0.1f).addBlock(Blocks.field_150347_e.func_176223_P(), 0.05f).addBlock(Blocks.field_196700_dk.func_176223_P(), 0.1f).addBlock(Blocks.field_201941_jj.func_176223_P(), 0.2f);
    public static BlockSetSelector ICE = new BlockSetSelector(Blocks.field_150403_cj.func_176223_P()).addBlock(Blocks.field_205164_gk.func_176223_P(), 0.4f).addBlock(Blocks.field_196604_cC.func_176223_P(), 0.1f).addBlock(Blocks.field_201941_jj.func_176223_P(), 0.1f);
    public static BlockSetSelector DESERT = new BlockSetSelector(Blocks.field_150322_A.func_176223_P()).addBlock(Blocks.field_150354_m.func_176223_P(), 0.3f).addBlock(Blocks.field_196583_aj.func_176223_P(), 0.1f).addBlock(Blocks.field_196585_ak.func_176223_P(), 0.1f).addBlock(Blocks.field_196580_bH.func_176223_P(), 0.1f).addBlock(Blocks.field_196696_di.func_176223_P(), 0.05f).addBlock(Blocks.field_196700_dk.func_176223_P(), 0.05f).addBlock(Blocks.field_201941_jj.func_176223_P(), 0.2f);
    public static BlockSetSelector RED_DESERT = new BlockSetSelector(Blocks.field_180395_cM.func_176223_P()).addBlock(Blocks.field_196611_F.func_176223_P(), 0.3f).addBlock(Blocks.field_196798_hA.func_176223_P(), 0.1f).addBlock(Blocks.field_196799_hB.func_176223_P(), 0.1f).addBlock(Blocks.field_196582_bJ.func_176223_P(), 0.1f).addBlock(Blocks.field_196696_di.func_176223_P(), 0.05f).addBlock(Blocks.field_196700_dk.func_176223_P(), 0.05f).addBlock(Blocks.field_201941_jj.func_176223_P(), 0.2f);
    public static BlockSetSelector MUSHROOM = new BlockSetSelector().addBlock(Blocks.field_196706_do.func_176223_P(), 0.33333f).addBlock(Blocks.field_150420_aW.func_176223_P(), 0.33333f).addBlock(Blocks.field_150419_aX.func_176223_P(), 0.33333f);
    public static BlockSetSelector ACACIA = new BlockSetSelector(Blocks.field_196670_r.func_176223_P()).addBlock(Blocks.field_150347_e.func_176223_P(), 0.1f).addBlock(Blocks.field_196696_di.func_176223_P(), 0.1f).addBlock(Blocks.field_196698_dj.func_176223_P(), 0.1f).addBlock(Blocks.field_196700_dk.func_176223_P(), 0.1f).addBlock(Blocks.field_201941_jj.func_176223_P(), 0.2f);
    public static BlockSetSelector STONE_BRICK_NORMAL = new BlockSetSelector().addBlock(Blocks.field_196696_di.func_176223_P(), 0.33333f).addBlock(Blocks.field_196698_dj.func_176223_P(), 0.33333f).addBlock(Blocks.field_196700_dk.func_176223_P(), 0.33333f);
    public static BlockSetSelector STONE_BRICK_JUNGLE = new BlockSetSelector().addBlock(Blocks.field_196696_di.func_176223_P(), 0.25f).addBlock(Blocks.field_196698_dj.func_176223_P(), 0.25f).addBlock(Blocks.field_196700_dk.func_176223_P(), 0.25f).addBlock(Blocks.field_196702_dl.func_176223_P(), 0.25f);
    public static BlockSetSelector STONE_BRICK_SNOW = new BlockSetSelector().addBlock(Blocks.field_196604_cC.func_176223_P(), 0.5f).addBlock(Blocks.field_150403_cj.func_176223_P(), 0.25f).addBlock(Blocks.field_205164_gk.func_176223_P(), 0.25f);
    public static BlockSetSelector STONE_BRICK_ICE = new BlockSetSelector().addBlock(Blocks.field_150403_cj.func_176223_P(), 0.5f).addBlock(Blocks.field_205164_gk.func_176223_P(), 0.5f);
    public static BlockSetSelector STONE_BRICK_DESERT = new BlockSetSelector().addBlock(Blocks.field_150354_m.func_176223_P(), 0.25f).addBlock(Blocks.field_150322_A.func_176223_P(), 0.25f).addBlock(Blocks.field_196580_bH.func_176223_P(), 0.2f).addBlock(Blocks.field_196585_ak.func_176223_P(), 0.2f).addBlock(Blocks.field_196583_aj.func_176223_P(), 0.1f);
    public static BlockSetSelector STONE_BRICK_RED_DESERT = new BlockSetSelector().addBlock(Blocks.field_196611_F.func_176223_P(), 0.25f).addBlock(Blocks.field_180395_cM.func_176223_P(), 0.25f).addBlock(Blocks.field_196582_bJ.func_176223_P(), 0.2f).addBlock(Blocks.field_196799_hB.func_176223_P(), 0.2f).addBlock(Blocks.field_196798_hA.func_176223_P(), 0.1f);
    public static BlockSetSelector STONE_BRICK_MUSHROOM = new BlockSetSelector().addBlock(Blocks.field_196706_do.func_176223_P(), 0.33333f).addBlock(Blocks.field_150420_aW.func_176223_P(), 0.33333f).addBlock(Blocks.field_150419_aX.func_176223_P(), 0.33333f);
    private List<Pair<BlockState, Float>> entries = new ArrayList<Pair<BlockState, Float>>();
    private BlockState defaultBlock = Blocks.field_201941_jj.func_176223_P();

    public BlockSetSelector() {
    }

    public BlockSetSelector(BlockState defaultBlock) {
        this.defaultBlock = defaultBlock;
    }

    public static BlockSetSelector from(BlockState ... blockStates) {
        BlockSetSelector selector = new BlockSetSelector();
        float chance = 1.0f / (float)blockStates.length;
        for (BlockState state : blockStates) {
            selector.addBlock(state, chance);
        }
        return selector;
    }

    public BlockSetSelector addBlock(BlockState blockState, float chance) {
        for (Pair<BlockState, Float> entry : this.entries) {
            if (entry.getFirst() != blockState) continue;
            BetterMineshafts.LOGGER.warn(String.format("WARNING: duplicate block %s added to BlockSelector!", blockState.toString()));
            return this;
        }
        float currTotal = (float)this.entries.stream().mapToDouble(Pair::getSecond).sum();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            BetterMineshafts.LOGGER.warn(String.format("WARNING: block %s added to BlockSelector exceeds max probabiltiy of 1!", blockState.toString()));
            return this;
        }
        this.entries.add((Pair<BlockState, Float>)new Pair((Object)blockState, (Object)Float.valueOf(chance)));
        return this;
    }

    public BlockState get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Pair<BlockState, Float> entry : this.entries) {
            float chance = ((Float)entry.getSecond()).floatValue();
            if (currBottom <= target && target < currBottom + chance) {
                return (BlockState)entry.getFirst();
            }
            currBottom += chance;
        }
        return this.defaultBlock;
    }
}

