/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer;

import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer.MechanicalSqueezerRecipeJEI;

public class MechanicalSqueezerRecipeCategory
implements IRecipeCategory<MechanicalSqueezerRecipeJEI> {
    public static final ResourceLocation NAME = new ResourceLocation("integrateddynamicscompat", "mechanical_squeezer");
    private static final int INPUT_SLOT = 0;
    private static final int FLUIDOUTPUT_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrowDrawable;

    public MechanicalSqueezerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("integrateddynamicscompat", "textures/gui/mechanical_squeezer_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 116, 53);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RegistryEntries.BLOCK_MECHANICAL_SQUEEZER));
        this.arrowDrawable = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(resourceLocation, 116, 0, 4, 11), 20, IDrawableAnimated.StartDirection.TOP, false);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return NAME;
    }

    public Class<? extends MechanicalSqueezerRecipeJEI> getRecipeClass() {
        return MechanicalSqueezerRecipeJEI.class;
    }

    @Nonnull
    public String getTitle() {
        return new TranslationTextComponent(RegistryEntries.BLOCK_MECHANICAL_SQUEEZER.func_149739_a(), new Object[0]).getString();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MechanicalSqueezerRecipeJEI recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getInputItem());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems().stream().map(RecipeSqueezer.ItemStackChance::getItemStack).collect(Collectors.toList()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutputFluid());
    }

    public void setRecipe(IRecipeLayout recipeLayout, MechanicalSqueezerRecipeJEI recipe, IIngredients ingredients) {
        int i;
        recipeLayout.getItemStacks().init(0, true, 1, 17);
        int offset = 0;
        for (i = 0; i < recipe.getOutputItems().size(); ++i) {
            recipeLayout.getItemStacks().init(2 + i, false, 75 + (i % 2 > 0 ? 22 : 0), 7 + offset + (i > 1 ? 22 : 0));
        }
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex > 2 && slotIndex < 2 + recipe.getOutputItems().size()) {
                float chance = ((RecipeSqueezer.ItemStackChance)recipe.getOutputItems().get(slotIndex - 2)).getChance();
                tooltip.add(TextFormatting.GRAY + "Chance: " + chance * 100.0f + "%");
            }
        });
        if (!recipe.getInputItem().isEmpty()) {
            recipeLayout.getItemStacks().set(0, recipe.getInputItem());
        }
        i = 0;
        for (RecipeSqueezer.ItemStackChance outputItem : recipe.getOutputItems()) {
            recipeLayout.getItemStacks().set(2 + i++, outputItem.getItemStack());
        }
        recipeLayout.getFluidStacks().init(1, false, 98, 30, 16, 16, 1000, false, null);
        if (recipe.getOutputFluid() != null) {
            recipeLayout.getFluidStacks().set(1, recipe.getOutputFluid());
        }
    }

    public void draw(MechanicalSqueezerRecipeJEI recipe, double mouseX, double mouseY) {
        this.arrowDrawable.draw(45, 21);
    }
}

