/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IDelayVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.evaluate.DelayVariableFacadeHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.item.DelayVariableFacade;
import org.cyclops.integrateddynamics.inventory.container.ContainerDelay;
import org.cyclops.integrateddynamics.network.DelayNetworkElement;
import org.cyclops.integrateddynamics.tileentity.TileProxy;

public class TileDelay
extends TileProxy
implements INamedContainerProvider {
    public static final int INVENTORY_SIZE = 3;
    protected Queue<IValue> values = null;
    @NBTPersist
    private int capacity = 5;
    @NBTPersist
    private int updateInterval = 1;
    private ValueTypeList.ValueList list = ValueTypes.LIST.getDefault();
    private final IVariable<?> variable = new VariableAdapter<ValueTypeList.ValueList>(){

        public ValueTypeList getType() {
            return ValueTypes.LIST;
        }

        @Override
        public ValueTypeList.ValueList getValue() throws EvaluationException {
            return TileDelay.this.list;
        }
    };
    private PlayerEntity lastPlayer = null;

    public TileDelay() {
        super(RegistryEntries.TILE_ENTITY_DELAY, 3);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new DelayNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        }));
    }

    @Override
    public ItemStack writeProxyInfo(boolean generateId, ItemStack itemStack, final int proxyId) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, DelayVariableFacadeHandler.getInstance(), new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IDelayVariableFacade>(){

            @Override
            public IDelayVariableFacade create(boolean generateId) {
                return new DelayVariableFacade(generateId, proxyId);
            }

            @Override
            public IDelayVariableFacade create(int id) {
                return new DelayVariableFacade(id, proxyId);
            }
        }, this.lastPlayer, this.func_195044_w());
    }

    @Override
    public IVariable<?> getVariable(IPartNetwork network) {
        return this.variable;
    }

    public void setCapacity(int capacity) {
        this.capacity = Math.max(1, capacity);
        this.values = Queues.newArrayBlockingQueue((int)this.capacity);
    }

    public Queue<IValue> getValues() {
        if (this.values == null) {
            this.values = Queues.newArrayBlockingQueue((int)this.capacity);
        }
        return this.values;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        ListNBT valueList = new ListNBT();
        for (IValue value : this.getValues()) {
            valueList.add((Object)ValueHelpers.serialize(value));
        }
        tag.func_218657_a("values", (INBT)valueList);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        if (this.capacity <= 0) {
            this.capacity = 1;
        }
        this.values = Queues.newArrayBlockingQueue((int)this.capacity);
        ListNBT valueList = tag.func_150295_c("values", 10);
        for (int i = 0; i < valueList.size(); ++i) {
            IValue value = ValueHelpers.deserialize(valueList.func_150305_b(i));
            if (value == null) continue;
            this.values.add(value);
        }
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().field_72995_K && this.updateInterval > 0 && this.func_145831_w().func_82737_E() % (long)this.updateInterval == 0L) {
            while (this.getValues().size() >= this.capacity) {
                this.getValues().poll();
            }
            IPartNetwork partNetwork = (IPartNetwork)NetworkHelpers.getPartNetwork(this.getNetwork()).orElse(null);
            if (partNetwork == null) {
                return;
            }
            IVariable<?> variable = super.getVariable(partNetwork);
            IValue value = null;
            if (variable != null) {
                try {
                    value = (IValue)variable.getValue();
                }
                catch (EvaluationException e) {
                    this.getEvaluator().addError((ITextComponent)new TranslationTextComponent(e.toString(), new Object[0]));
                }
                if (value != null) {
                    try {
                        if (this.list.getRawValue().getLength() > 0 && this.list.getRawValue().getValueType() != value.getType()) {
                            this.getValues().clear();
                        }
                    }
                    catch (EvaluationException evaluationException) {
                        // empty catch block
                    }
                    this.getValues().add(value);
                    this.list = ValueTypeList.ValueList.ofList(value.getType(), Lists.newArrayList(this.values));
                }
            } else {
                this.getValues().clear();
                this.list = ValueTypes.LIST.getDefault();
            }
            this.variable.invalidate();
        }
    }

    @Override
    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerDelay(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.integrateddynamics.delay", new Object[0]);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Override
    public void setLastPlayer(PlayerEntity lastPlayer) {
        this.lastPlayer = lastPlayer;
    }
}

