/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotSingleItem;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public abstract class ContainerLogicProgrammerBase
extends ScrollingInventoryContainer<ILogicProgrammerElement>
implements IDirtyMarkListener {
    public static final int OUTPUT_X = 232;
    public static final int OUTPUT_Y = 110;
    protected static final ScrollingInventoryContainer.IItemPredicate<ILogicProgrammerElement> FILTERER = (item, pattern) -> pattern.matcher(item.getMatchString()).matches() || pattern.matcher(item.getSymbol()).matches();
    private final SimpleInventory writeSlot = new SimpleInventory(1, 1);
    private final SimpleInventory filterSlots = new SimpleInventory(3, 1);
    private ILogicProgrammerElement activeElement = null;
    private ILogicProgrammerElement temporarySlotsElement = null;
    private SimpleInventory temporaryInputSlots = null;
    private ITextComponent lastError;
    private LoadConfigListener loadConfigListener;
    private IValueType filterIn1 = null;
    private IValueType filterIn2 = null;
    private IValueType filterOut = null;
    @OnlyIn(value=Dist.CLIENT)
    private ContainerScreenLogicProgrammerBase gui;
    private String lastLabel = "";

    public ContainerLogicProgrammerBase(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory) {
        super(type, id, playerInventory, (IInventory)new Inventory(0), ContainerLogicProgrammerBase.getElements(), FILTERER);
        this.filterSlots.addDirtyMarkListener((IDirtyMarkListener)new FilterSlotListener());
        this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this);
        this.loadConfigListener = new LoadConfigListener();
        this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this.loadConfigListener);
        this.temporaryInputSlots = new SimpleInventory(0, 1);
        this.initializeSlotsPre();
        this.initializeSlotsPost();
    }

    protected static List<ILogicProgrammerElement> getElements() {
        LinkedList elements = Lists.newLinkedList();
        for (ILogicProgrammerElementType type : LogicProgrammerElementTypes.REGISTRY.getTypes()) {
            elements.addAll(type.createElements());
        }
        return elements;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGui(ContainerScreenLogicProgrammerBase gui) {
        this.gui = gui;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ContainerScreenLogicProgrammerBase getGui() {
        return this.gui;
    }

    protected void initializeSlotsPre() {
        this.func_75146_a((Slot)new SlotSingleItem((IInventory)this.writeSlot, 0, 232, 110, (Item)RegistryEntries.ITEM_VARIABLE));
        SlotSingleItem filterSlotIn1 = new SlotSingleItem((IInventory)this.filterSlots, 0, 6, 218, (Item)RegistryEntries.ITEM_VARIABLE);
        SlotSingleItem filterSlotIn2 = new SlotSingleItem((IInventory)this.filterSlots, 1, 24, 218, (Item)RegistryEntries.ITEM_VARIABLE);
        SlotSingleItem filterSlotOut = new SlotSingleItem((IInventory)this.filterSlots, 2, 58, 218, (Item)RegistryEntries.ITEM_VARIABLE);
        filterSlotIn1.setPhantom(true);
        filterSlotIn2.setPhantom(true);
        filterSlotOut.setPhantom(true);
        this.func_75146_a((Slot)filterSlotIn1);
        this.func_75146_a((Slot)filterSlotIn2);
        this.func_75146_a((Slot)filterSlotOut);
    }

    protected void initializeSlotsPost() {
        this.addPlayerInventory((PlayerInventory)this.getPlayerIInventory(), 88, 131);
    }

    public int getPageSize() {
        return 10;
    }

    protected boolean isAssertInventorySize() {
        return false;
    }

    protected int getSizeInventory() {
        return 1;
    }

    public void setActiveElementById(ResourceLocation typeId, ResourceLocation elementId) {
        ILogicProgrammerElementType type = LogicProgrammerElementTypes.REGISTRY.getType(typeId);
        if (type != null) {
            Object element = type.getByName(elementId);
            if (!LogicProgrammerElementTypes.areEqual(this.getActiveElement(), element)) {
                this.setActiveElement((ILogicProgrammerElement)element, 0, 0);
                this.onDirty();
            }
        } else {
            this.setActiveElement(null, 0, 0);
        }
    }

    public void setActiveElement(ILogicProgrammerElement activeElement, int baseX, int baseY) {
        if (this.activeElement != null) {
            this.activeElement.deactivate();
        }
        this.activeElement = activeElement;
        this.lastError = null;
        this.activeElement = activeElement;
        this.setElementInventory(this.activeElement, baseX, baseY);
        if (activeElement != null) {
            activeElement.activate();
        }
    }

    public void setElementInventory(ILogicProgrammerElement element, int baseX, int baseY) {
        this.lastError = null;
        this.field_75153_a.clear();
        this.field_75151_b.clear();
        this.initializeSlotsPre();
        this.temporaryInputSlots.removeDirtyMarkListener((IDirtyMarkListener)this);
        this.temporaryInputSlots = new SimpleInventory(element == null ? 0 : element.getRenderPattern().getSlotPositions().length, element == null ? 0 : element.getItemStackSizeLimit());
        this.temporaryInputSlots.addDirtyMarkListener((IDirtyMarkListener)this);
        this.temporarySlotsElement = element;
        if (element != null) {
            Pair<Integer, Integer>[] slotPositions = element.getRenderPattern().getSlotPositions();
            for (int i = 0; i < this.temporaryInputSlots.func_70302_i_(); ++i) {
                this.func_75146_a(element.createSlot((IInventory)this.temporaryInputSlots, i, 1 + baseX + (Integer)slotPositions[i].getLeft(), 1 + baseY + (Integer)slotPositions[i].getRight()));
            }
        }
        this.initializeSlotsPost();
        this.lastLabel = "";
    }

    public boolean canWriteActiveElementPre() {
        if (this.activeElement != null) {
            return this.activeElement.canWriteElementPre();
        }
        return false;
    }

    public boolean canWriteActiveElement() {
        if (!this.canWriteActiveElementPre()) {
            return false;
        }
        this.lastError = this.activeElement.validate();
        return this.lastError == null;
    }

    public ILogicProgrammerElement getActiveElement() {
        return this.activeElement;
    }

    public void func_75134_a(PlayerEntity player) {
        ItemStack itemStack;
        super.func_75134_a(player);
        if (!player.field_70170_p.func_201670_d() && !(itemStack = this.writeSlot.func_70301_a(0)).func_190926_b()) {
            player.func_71019_a(itemStack, false);
        }
    }

    public void onLabelPacket(String label) {
        this.lastLabel = label;
        this.labelCurrent();
    }

    protected void labelCurrent() {
        ItemStack itemStack = this.writeSlot.func_70301_a(0);
        if (!itemStack.func_190926_b()) {
            IVariableFacade variableFacade = RegistryEntries.ITEM_VARIABLE.getVariableFacade(itemStack);
            if (this.lastLabel != null && variableFacade.isValid()) {
                LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).put(variableFacade.getId(), this.lastLabel);
            }
        }
    }

    protected ItemStack writeElementInfo() {
        ItemStack itemStack = this.writeSlot.func_70301_a(0);
        ItemStack result = this.getActiveElement().writeElement(this.player, itemStack.func_77946_l());
        return result;
    }

    public void onDirty() {
        ILogicProgrammerElement activeElement = this.getActiveElement();
        if (activeElement != null) {
            for (int i = 0; i < this.temporaryInputSlots.func_70302_i_(); ++i) {
                ItemStack itemStack = this.temporaryInputSlots.func_70301_a(i);
                this.temporarySlotsElement.onInputSlotUpdated(i, itemStack);
            }
        }
        ItemStack itemStack = this.writeSlot.func_70301_a(0);
        if (this.canWriteActiveElement() && !itemStack.func_190926_b()) {
            ItemStack outputStack = this.writeElementInfo();
            this.writeSlot.removeDirtyMarkListener((IDirtyMarkListener)this);
            this.writeSlot.func_70299_a(0, outputStack);
            if (!StringUtils.func_151246_b((String)this.lastLabel)) {
                this.labelCurrent();
            }
            this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this);
        }
    }

    protected void loadConfigFrom(ItemStack itemStack) {
        if (MinecraftHelpers.isClientSide()) {
            IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            IVariableFacade variableFacade = registry.handle(itemStack);
            for (ILogicProgrammerElement element : ContainerLogicProgrammerBase.getElements()) {
                if (!element.isFor(variableFacade)) continue;
                this.getGui().handleElementActivation(element);
            }
        }
    }

    public ITextComponent getLastError() {
        return this.lastError;
    }

    public IInventory getTemporaryInputSlots() {
        return this.temporaryInputSlots;
    }

    public boolean hasWriteItemInSlot() {
        return !this.writeSlot.func_70301_a(0).func_190926_b();
    }

    protected boolean additionalApplies(ILogicProgrammerElement item) {
        return !((this.filterIn1 != null && !item.matchesInput(this.filterIn1) || this.filterIn2 != null && !item.matchesInput(this.filterIn2)) && (this.filterIn1 != null || this.filterIn2 != null) || this.filterOut != null && !item.matchesOutput(this.filterOut));
    }

    public ItemStack func_184996_a(int slotId, int mouseButton, ClickType clickType, PlayerEntity player) {
        if (slotId >= this.field_75151_b.size() || this.activeElement != null && this.field_75151_b.size() > slotId && slotId >= 0 && this.activeElement.slotClick(slotId, this.func_75139_a(slotId), mouseButton, clickType, player)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, mouseButton, clickType, player);
    }

    protected class FilterSlotListener
    implements IDirtyMarkListener {
        protected FilterSlotListener() {
        }

        protected IValueType getValueType(IInventory inventory, int slot) {
            IVariableFacade variableFacade;
            IVariableFacadeHandlerRegistry handler = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            if (inventory.func_70301_a(slot) != null && (variableFacade = handler.handle(inventory.func_70301_a(slot))).isValid()) {
                return variableFacade.getOutputType();
            }
            return null;
        }

        public void onDirty() {
            IValueType filterIn1Prev = ContainerLogicProgrammerBase.this.filterIn1;
            IValueType filterIn2Prev = ContainerLogicProgrammerBase.this.filterIn2;
            IValueType filterOutPrev = ContainerLogicProgrammerBase.this.filterOut;
            ContainerLogicProgrammerBase.this.filterIn1 = this.getValueType((IInventory)ContainerLogicProgrammerBase.this.filterSlots, 0);
            ContainerLogicProgrammerBase.this.filterIn2 = this.getValueType((IInventory)ContainerLogicProgrammerBase.this.filterSlots, 1);
            ContainerLogicProgrammerBase.this.filterOut = this.getValueType((IInventory)ContainerLogicProgrammerBase.this.filterSlots, 2);
            if (filterIn1Prev != ContainerLogicProgrammerBase.this.filterIn1 || filterIn2Prev != ContainerLogicProgrammerBase.this.filterIn2 || filterOutPrev != ContainerLogicProgrammerBase.this.filterOut) {
                ContainerLogicProgrammerBase.this.refreshFilter();
            }
        }
    }

    protected class LoadConfigListener
    implements IDirtyMarkListener {
        protected LoadConfigListener() {
        }

        public void onDirty() {
        }
    }
}

