/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventoryState;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableTile;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class TileCableConnectableInventory
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private final ICable cable;
    private final INetworkCarrier networkCarrier;
    private final SimpleInventory inventory;

    public TileCableConnectableInventory(TileEntityType<?> type, int inventorySize, int stackSize) {
        super(type);
        this.inventory = this.createInventory(inventorySize, stackSize);
        this.cable = new CableTile<TileCableConnectableInventory>(this){

            @Override
            protected boolean isForceDisconnectable() {
                return false;
            }

            @Override
            protected EnumFacingMap<Boolean> getForceDisconnected() {
                return null;
            }

            @Override
            protected EnumFacingMap<Boolean> getConnected() {
                return ((TileCableConnectableInventory)this.tile).connected;
            }
        };
        this.addCapabilityInternal(CableConfig.CAPABILITY, LazyOptional.of(() -> this.cable));
        this.networkCarrier = new NetworkCarrierDefault();
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, LazyOptional.of(() -> this.networkCarrier));
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, LazyOptional.of(() -> new PathElementTile<TileCableConnectableInventory>(this, this.cable)));
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> ((SimpleInventory)this.inventory).getItemHandler()));
        this.addCapabilityInternal(Capabilities.INVENTORY_STATE, LazyOptional.of(() -> new SimpleInventoryState(this.getInventory())));
    }

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize);
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.connected.clear();
        this.inventory.readFromNBT(tag, "inventory");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.writeToNBT(tag, "inventory");
        return super.func_189515_b(tag);
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.connected.isEmpty()) {
            this.cable.updateConnections();
        }
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            NetworkHelpers.revalidateNetworkElements(this.func_145831_w(), this.func_174877_v());
        }
    }

    public void afterNetworkReAlive() {
    }

    @Nullable
    public INetwork getNetwork() {
        return this.networkCarrier.getNetwork();
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            NetworkHelpers.invalidateNetworkElements(this.func_145831_w(), this.func_174877_v(), (TileEntity)this);
        }
    }

    public ICable getCable() {
        return this.cable;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

