/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchType;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeRecipeValueChangedPacket;

public class ValueTypeRecipeLPElement
extends ValueTypeLPElementBase {
    @OnlyIn(value=Dist.CLIENT)
    private SubGuiRenderPattern lastGui;
    private NonNullList<Pair<ItemStack, ItemMatchType>> inputStacks;
    private ItemStack inputFluid;
    private String inputFluidAmount = "0";
    private String inputEnergy = "0";
    private NonNullList<ItemStack> outputStacks;
    private ItemStack outputFluid;
    private String outputFluidAmount = "0";
    private String outputEnergy = "0";

    public static ItemMatchType getDefaultItemMatch() {
        return ItemMatchType.ITEM;
    }

    public ValueTypeRecipeLPElement() {
        super(ValueTypes.OBJECT_RECIPE);
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.RECIPE;
    }

    @Override
    public void onInputSlotUpdated(int slotId, ItemStack itemStack) {
        int amount;
        if (this.inputStacks == null) {
            return;
        }
        if (slotId >= 0 && slotId < 9) {
            this.inputStacks.set(slotId, (Object)Pair.of((Object)itemStack.func_77946_l(), (Object)((Pair)this.inputStacks.get(slotId)).getRight()));
        }
        if (slotId == 9) {
            this.inputFluid = itemStack.func_77946_l();
            if (this.inputFluidAmount.equalsIgnoreCase("0")) {
                amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack(this.inputFluid));
                this.inputFluidAmount = Integer.toString(amount);
                if (MinecraftHelpers.isClientSideThread() && this.lastGui != null) {
                    this.refreshInputFluidAmountBox();
                }
            }
        }
        if (slotId > 9 && slotId < 13) {
            this.outputStacks.set(slotId - 10, (Object)itemStack.func_77946_l());
        }
        if (slotId == 13) {
            this.outputFluid = itemStack.func_77946_l();
            if (this.outputFluidAmount.equalsIgnoreCase("0")) {
                amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack(this.outputFluid));
                this.outputFluidAmount = Integer.toString(amount);
                if (MinecraftHelpers.isClientSideThread() && this.lastGui != null) {
                    this.refreshOutputFluidAmountBox();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshInputFluidAmountBox() {
        if (this.lastGui != null && this.lastGui.getInputFluidAmountBox() != null) {
            this.lastGui.getInputFluidAmountBox().func_146180_a(this.inputFluidAmount);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshOutputFluidAmountBox() {
        if (this.lastGui != null && this.lastGui.getOutputFluidAmountBox() != null) {
            this.lastGui.getOutputFluidAmountBox().func_146180_a(this.outputFluidAmount);
        }
    }

    public boolean isValidForRecipeGrid(List<ItemStack> itemInputs, List<FluidStack> fluidInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs) {
        return itemInputs.size() <= 9 && itemOutputs.size() <= 3 && fluidInputs.size() <= 1 && fluidOutputs.size() <= 1;
    }

    protected void putStackInContainer(ContainerLogicProgrammerBase container, int slot, ItemStack itemStack) {
        container.func_75141_a(container.field_75151_b.size() - 50 + slot, itemStack);
    }

    /*
     * WARNING - void declaration
     */
    public void setRecipeGrid(ContainerLogicProgrammerBase container, List<ItemStack> itemInputs, List<FluidStack> fluidInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs) {
        void var8_12;
        int slot = 0;
        for (ItemStack itemStack : itemInputs) {
            this.putStackInContainer(container, slot, itemStack);
            ++slot;
        }
        while (slot < 9) {
            this.putStackInContainer(container, slot, ItemStack.field_190927_a);
            ++slot;
        }
        slot = 9;
        FluidStack fluidStackInput = FluidStack.EMPTY;
        if (fluidInputs.size() > 0) {
            fluidStackInput = fluidInputs.get(0);
        }
        this.putStackInContainer(container, slot, fluidStackInput.isEmpty() ? ItemStack.field_190927_a : this.getFluidBucket(fluidStackInput));
        this.inputFluidAmount = String.valueOf(FluidHelpers.getAmount((FluidStack)fluidStackInput));
        if (MinecraftHelpers.isClientSideThread()) {
            this.refreshInputFluidAmountBox();
        }
        slot = 10;
        for (ItemStack itemOutput : itemOutputs) {
            this.putStackInContainer(container, slot, itemOutput);
            ++slot;
        }
        while (slot < 13) {
            this.putStackInContainer(container, slot, ItemStack.field_190927_a);
            ++slot;
        }
        slot = 13;
        FluidStack fluidStack = FluidStack.EMPTY;
        if (fluidOutputs.size() > 0) {
            FluidStack fluidStack2 = fluidOutputs.get(0);
        }
        this.putStackInContainer(container, slot, var8_12.isEmpty() ? ItemStack.field_190927_a : this.getFluidBucket((FluidStack)var8_12));
        this.outputFluidAmount = String.valueOf(FluidHelpers.getAmount((FluidStack)var8_12));
        if (MinecraftHelpers.isClientSideThread()) {
            this.refreshOutputFluidAmountBox();
        }
    }

    protected ItemStack getFluidBucket(FluidStack fluidStack) {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_151133_ar);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        fluidHandler.fill(new FluidStack(fluidStack, 1000), IFluidHandler.FluidAction.EXECUTE);
        return fluidHandler.getContainer();
    }

    protected boolean isInputValid() {
        return this.inputStacks.stream().anyMatch(stack -> !((ItemStack)stack.getLeft()).func_190926_b()) || !this.inputFluid.func_190926_b() || !this.inputFluidAmount.equalsIgnoreCase("0") || !this.inputEnergy.equalsIgnoreCase("0");
    }

    protected boolean isOutputValid() {
        return this.outputStacks.stream().anyMatch(stack -> !stack.func_190926_b()) || !this.outputFluid.func_190926_b() || !this.outputFluidAmount.equalsIgnoreCase("0") || !this.outputEnergy.equalsIgnoreCase("0");
    }

    @Override
    public boolean canWriteElementPre() {
        return this.isInputValid() == this.isOutputValid();
    }

    @Override
    public void activate() {
        this.inputStacks = NonNullList.func_191197_a((int)9, (Object)Pair.of((Object)ItemStack.field_190927_a, (Object)((Object)ValueTypeRecipeLPElement.getDefaultItemMatch())));
        this.inputFluid = ItemStack.field_190927_a;
        this.inputFluidAmount = "0";
        this.inputEnergy = "0";
        this.outputStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
        this.outputFluid = ItemStack.field_190927_a;
        this.outputFluidAmount = "0";
        this.outputEnergy = "0";
    }

    @Override
    public void deactivate() {
    }

    @Override
    public ITextComponent validate() {
        if (!this.inputFluid.func_190926_b() && Helpers.getFluidStack(this.inputFluid).isEmpty()) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.fluid.no_fluid", new Object[0]);
        }
        if (!this.outputFluid.func_190926_b() && Helpers.getFluidStack(this.outputFluid).isEmpty()) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.fluid.no_fluid", new Object[0]);
        }
        try {
            Integer.parseInt(this.inputFluidAmount);
        }
        catch (NumberFormatException e) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.inputFluidAmount});
        }
        try {
            Integer.parseInt(this.outputFluidAmount);
        }
        catch (NumberFormatException e) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.outputFluidAmount});
        }
        try {
            Integer.parseInt(this.inputEnergy);
        }
        catch (NumberFormatException e) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.inputEnergy});
        }
        try {
            Integer.parseInt(this.outputEnergy);
        }
        catch (NumberFormatException e) {
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.outputEnergy});
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return true;
    }

    @Override
    public Slot createSlot(IInventory temporaryInputSlots, int slotId, int x, int y) {
        Slot slot = ILogicProgrammerElement.createSlotDefault(this, temporaryInputSlots, slotId, x, y);
        if (slotId < 9) {
            slot.setBackground(AtlasTexture.field_110575_b, ValueTypeRecipeLPElement.getDefaultItemMatch().getSlotSpriteName());
        }
        return slot;
    }

    @Override
    public boolean slotClick(int slotId, Slot slot, int mouseButton, ClickType clickType, PlayerEntity player) {
        if (slotId >= 4 && slotId < 13 && mouseButton == 0 && clickType == ClickType.QUICK_MOVE) {
            int id = slotId - 4;
            this.inputStacks.set(id, (Object)Pair.of((Object)((Pair)this.inputStacks.get(id)).getLeft(), (Object)((Object)((ItemMatchType)((Object)((Pair)this.inputStacks.get(id)).getRight())).next())));
            slot.setBackground(AtlasTexture.field_110575_b, ((ItemMatchType)((Object)((Pair)this.inputStacks.get(id)).getRight())).getSlotSpriteName());
            return true;
        }
        return super.slotClick(slotId, slot, mouseButton, clickType, player);
    }

    @Override
    public int getItemStackSizeLimit() {
        return 64;
    }

    protected Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getInputs(List<Pair<ItemStack, ItemMatchType>> itemStacks, ItemStack fluid, int fluidAmount, int energy) {
        List energies;
        int lastNonEmpty = 0;
        for (int i = 0; i < itemStacks.size(); ++i) {
            if (((ItemStack)itemStacks.get(i).getLeft()).func_190926_b()) continue;
            lastNonEmpty = i + 1;
        }
        itemStacks = itemStacks.subList(0, lastNonEmpty);
        FluidStack fluidStack = Helpers.getFluidStack(fluid);
        if (!fluidStack.isEmpty()) {
            fluidStack.setAmount(fluidAmount);
        }
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        List items = itemStacks.stream().map(stack -> ((ItemMatchType)((Object)((Object)stack.getRight()))).getPrototypeHandler().getPrototypesFor((ItemStack)stack.getLeft())).collect(Collectors.toList());
        List fluids = !fluidStack.isEmpty() ? Collections.singletonList(new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.FLUIDSTACK, (Object)fluidStack, (Object)3)))) : Collections.emptyList();
        List<Object> list = energies = energy > 0 ? Collections.singletonList(new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ENERGY, (Object)energy, (Object)false)))) : Collections.emptyList();
        if (!items.isEmpty()) {
            inputs.put(IngredientComponent.ITEMSTACK, items);
        }
        if (!fluids.isEmpty()) {
            inputs.put(IngredientComponent.FLUIDSTACK, fluids);
        }
        if (!energies.isEmpty()) {
            inputs.put(IngredientComponent.ENERGY, energies);
        }
        return inputs;
    }

    protected Map<IngredientComponent<?, ?>, List<?>> getOutputs(List<ItemStack> itemStacks, ItemStack fluid, int fluidAmount, int energy) {
        int lastNonEmpty = 0;
        for (int i = 0; i < itemStacks.size(); ++i) {
            if (itemStacks.get(i).func_190926_b()) continue;
            lastNonEmpty = i + 1;
        }
        itemStacks = itemStacks.subList(0, lastNonEmpty);
        FluidStack fluidStack = Helpers.getFluidStack(fluid);
        if (!fluidStack.isEmpty()) {
            fluidStack.setAmount(fluidAmount);
        }
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        if (!itemStacks.isEmpty()) {
            outputs.put(IngredientComponent.ITEMSTACK, itemStacks);
        }
        if (!fluidStack.isEmpty()) {
            outputs.put(IngredientComponent.FLUIDSTACK, Collections.singletonList(fluidStack));
        }
        if (energy > 0) {
            outputs.put(IngredientComponent.ENERGY, Collections.singletonList(energy));
        }
        return outputs;
    }

    @Override
    public IValue getValue() {
        if (!this.isInputValid() && !this.isOutputValid()) {
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }
        return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition(this.getInputs((List<Pair<ItemStack, ItemMatchType>>)this.inputStacks, this.inputFluid, Integer.parseInt(this.inputFluidAmount), Integer.parseInt(this.inputEnergy)), (IMixedIngredients)new MixedIngredients(this.getOutputs((List<ItemStack>)this.outputStacks, this.outputFluid, Integer.parseInt(this.outputFluidAmount), Integer.parseInt(this.outputEnergy)))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.lastGui = new SubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.lastGui;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setValueInGui(ISubGuiBox subGui) {
        int i;
        SubGuiRenderPattern gui = (SubGuiRenderPattern)subGui;
        IInventory slots = ((ContainerLogicProgrammerBase)gui.container).getTemporaryInputSlots();
        for (i = 0; i < this.inputStacks.size(); ++i) {
            Pair entry = (Pair)this.inputStacks.get(i);
            slots.func_70299_a(i, (ItemStack)entry.getLeft());
        }
        slots.func_70299_a(9, this.inputFluid);
        if (gui.getInputFluidAmountBox() != null) {
            gui.getInputFluidAmountBox().func_146180_a(this.inputFluidAmount);
            gui.getInputEnergyBox().func_146180_a(this.inputEnergy);
            for (i = 0; i < this.outputStacks.size(); ++i) {
                slots.func_70299_a(10 + i, (ItemStack)this.outputStacks.get(i));
            }
            slots.func_70299_a(13, this.outputFluid);
            gui.getOutputFluidAmountBox().func_146180_a(this.outputFluidAmount);
            gui.getOutputEnergyBox().func_146180_a(this.outputEnergy);
        }
    }

    public String getInputFluidAmount() {
        return this.inputFluidAmount;
    }

    public void setInputFluidAmount(String inputFluidAmount) {
        this.inputFluidAmount = inputFluidAmount;
    }

    public String getInputEnergy() {
        return this.inputEnergy;
    }

    public void setInputEnergy(String inputEnergy) {
        this.inputEnergy = inputEnergy;
    }

    public String getOutputFluidAmount() {
        return this.outputFluidAmount;
    }

    public void setOutputFluidAmount(String outputFluidAmount) {
        this.outputFluidAmount = outputFluidAmount;
    }

    public String getOutputEnergy() {
        return this.outputEnergy;
    }

    public void setOutputEnergy(String outputEnergy) {
        this.outputEnergy = outputEnergy;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class SubGuiRenderPattern
    extends RenderPattern<ValueTypeRecipeLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IRenderPatternValueTypeTooltip {
        private boolean renderTooltip = true;
        private WidgetTextFieldExtended inputFluidAmountBox = null;
        private WidgetTextFieldExtended inputEnergyBox = null;
        private WidgetTextFieldExtended outputFluidAmountBox = null;
        private WidgetTextFieldExtended outputEnergyBox = null;

        public SubGuiRenderPattern(ValueTypeRecipeLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        protected static WidgetTextFieldExtended makeTextBox(int componentId, int x, int y, String text) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int searchWidth = 35;
            fontRenderer.getClass();
            WidgetTextFieldExtended box = new WidgetTextFieldExtended(fontRenderer, x, y, searchWidth, 9 + 3, L10NHelpers.localize((String)"gui.cyclopscore.search", (Object[])new Object[0]), true);
            box.func_146203_f(10);
            box.func_146185_a(false);
            box.func_146189_e(true);
            box.func_146193_g(0xFFFFFF);
            box.func_146205_d(true);
            box.func_146180_a(text);
            box.setWidth(searchWidth);
            return box;
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            this.inputFluidAmountBox = SubGuiRenderPattern.makeTextBox(0, guiLeft + this.getX() + 21, guiTop + this.getY() + 59, ((ValueTypeRecipeLPElement)this.element).getInputFluidAmount());
            this.inputEnergyBox = SubGuiRenderPattern.makeTextBox(1, guiLeft + this.getX() + 21, guiTop + this.getY() + 77, ((ValueTypeRecipeLPElement)this.element).getInputEnergy());
            this.outputFluidAmountBox = SubGuiRenderPattern.makeTextBox(2, guiLeft + this.getX() + 101, guiTop + this.getY() + 59, ((ValueTypeRecipeLPElement)this.element).getOutputFluidAmount());
            this.outputEnergyBox = SubGuiRenderPattern.makeTextBox(3, guiLeft + this.getX() + 101, guiTop + this.getY() + 77, ((ValueTypeRecipeLPElement)this.element).getOutputEnergy());
        }

        @Override
        public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            this.drawTooltipForeground((ContainerScreenLogicProgrammerBase)this.gui, (ContainerLogicProgrammerBase)this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeRecipeLPElement)this.element).getValueType());
            for (int slotId = 0; slotId < ((ContainerLogicProgrammerBase)this.container).field_75151_b.size(); ++slotId) {
                com.mojang.datafixers.util.Pair slotTexturePair;
                Slot slot = (Slot)((ContainerLogicProgrammerBase)this.container).field_75151_b.get(slotId);
                if (slotId < 4 || slotId >= 13) continue;
                int slotX = slot.field_75223_e;
                int slotY = slot.field_75221_f;
                if (slot.func_75216_d() && slot.func_111238_b() && (slotTexturePair = slot.func_225517_c_()) != null) {
                    TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_((ResourceLocation)slotTexturePair.getFirst()).apply(slotTexturePair.getSecond());
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
                    SubGuiRenderPattern.blit((int)slotX, (int)slotY, (int)this.getBlitOffset(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
                }
                if (!((ContainerScreenLogicProgrammerBase)this.gui).func_195359_a(slotX, slotY, 16, 16, mouseX, mouseY)) continue;
                String name = "valuetype.integrateddynamics.ingredients.match." + ((ItemMatchType)((Object)((Pair)((ValueTypeRecipeLPElement)this.element).inputStacks.get(slot.getSlotIndex())).getRight())).name().toLowerCase(Locale.ENGLISH);
                ((ContainerScreenLogicProgrammerBase)this.gui).drawTooltip(Lists.newArrayList((Iterable)new TranslationTextComponent(name + ".desc", new Object[0]).func_150258_a(" ").func_211709_a(new TextFormatting[]{TextFormatting.ITALIC}).func_150257_a((ITextComponent)new TranslationTextComponent("valuetype.integrateddynamics.ingredients.slot.info", new Object[0]))), mouseX - guiLeft, mouseY - guiTop - 15);
            }
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            this.blit(guiLeft + this.getX() + 66, guiTop + this.getY() + 21, 0, 38, 22, 15);
            this.inputFluidAmountBox.render(mouseX, mouseY, partialTicks);
            fontRenderer.func_211126_b(L10NHelpers.localize((String)"general.integrateddynamics.energy_unit", (Object[])new Object[0]) + ":", (float)(guiLeft + this.getX() + 2), (float)(guiTop + this.getY() + 78), 0);
            this.inputEnergyBox.render(mouseX, mouseY, partialTicks);
            this.outputFluidAmountBox.render(mouseX, mouseY, partialTicks);
            fontRenderer.func_211126_b(L10NHelpers.localize((String)"general.integrateddynamics.energy_unit", (Object[])new Object[0]) + ":", (float)(guiLeft + this.getX() + 84), (float)(guiTop + this.getY() + 78), 0);
            this.outputEnergyBox.render(mouseX, mouseY, partialTicks);
        }

        @Override
        public boolean charTyped(char typedChar, int keyCode) {
            if (this.inputFluidAmountBox.charTyped(typedChar, keyCode)) {
                ((ValueTypeRecipeLPElement)this.element).setInputFluidAmount(this.inputFluidAmountBox.func_146179_b());
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getInputFluidAmount(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.INPUT_FLUID));
                return true;
            }
            if (this.inputEnergyBox.charTyped(typedChar, keyCode)) {
                ((ValueTypeRecipeLPElement)this.element).setInputEnergy(this.inputEnergyBox.func_146179_b());
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getInputEnergy(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.INPUT_ENERGY));
                return true;
            }
            if (this.outputFluidAmountBox.charTyped(typedChar, keyCode)) {
                ((ValueTypeRecipeLPElement)this.element).setOutputFluidAmount(this.outputFluidAmountBox.func_146179_b());
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getOutputFluidAmount(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.OUTPUT_FLUID));
                return true;
            }
            if (this.outputEnergyBox.charTyped(typedChar, keyCode)) {
                ((ValueTypeRecipeLPElement)this.element).setOutputEnergy(this.outputEnergyBox.func_146179_b());
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getOutputEnergy(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.OUTPUT_ENERGY));
                return true;
            }
            return super.charTyped(typedChar, keyCode);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            return this.inputFluidAmountBox.mouseClicked(mouseX, mouseY, mouseButton) || this.inputEnergyBox.mouseClicked(mouseX, mouseY, mouseButton) || this.outputFluidAmountBox.mouseClicked(mouseX, mouseY, mouseButton) || this.outputEnergyBox.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public boolean isRenderTooltip() {
            return this.renderTooltip;
        }

        @Override
        public void setRenderTooltip(boolean renderTooltip) {
            this.renderTooltip = renderTooltip;
        }

        public WidgetTextFieldExtended getInputFluidAmountBox() {
            return this.inputFluidAmountBox;
        }

        public WidgetTextFieldExtended getInputEnergyBox() {
            return this.inputEnergyBox;
        }

        public WidgetTextFieldExtended getOutputFluidAmountBox() {
            return this.outputFluidAmountBox;
        }

        public WidgetTextFieldExtended getOutputEnergyBox() {
            return this.outputEnergyBox;
        }
    }
}

