/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.ingredient;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public enum ItemMatchType {
    ITEM(new FlaggedPrototypeHandler(1)),
    ITEMNBT(new FlaggedPrototypeHandler(5)),
    TAG(itemStack -> new PrototypedIngredientAlternativesItemStackTag(ItemMatchType.getTagKeys(itemStack), Integer.valueOf(5), (long)itemStack.func_190916_E()));

    private static final LoadingCache<ItemStack, List<String>> CACHE_TAG;
    private final IPrototypeHandler prototypeHandler;

    protected static List<String> getTagKeys(ItemStack itemStack) {
        try {
            return (List)CACHE_TAG.get((Object)itemStack);
        }
        catch (ExecutionException e) {
            return Collections.emptyList();
        }
    }

    private ItemMatchType(IPrototypeHandler prototypeHandler) {
        this.prototypeHandler = prototypeHandler;
    }

    public ItemMatchType next() {
        ItemMatchType[] values = ItemMatchType.values();
        return this.ordinal() == values.length - 1 ? values[0] : values[this.ordinal() + 1];
    }

    public ResourceLocation getSlotSpriteName() {
        return new ResourceLocation("integrateddynamics", "slot/" + this.name().toLowerCase(Locale.ENGLISH));
    }

    public IPrototypeHandler getPrototypeHandler() {
        return this.prototypeHandler;
    }

    static {
        CACHE_TAG = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ItemStack, List<String>>(){

            public List<String> load(ItemStack key) {
                if (key.func_190926_b()) {
                    return Collections.emptyList();
                }
                return ItemTags.func_199903_a().func_199913_a((Object)key.func_77973_b()).stream().map(Objects::toString).collect(Collectors.toList());
            }
        });
    }

    public static class FlaggedPrototypeHandler
    implements IPrototypeHandler {
        private final int flags;

        public FlaggedPrototypeHandler(int flags) {
            this.flags = flags;
        }

        @Override
        public IPrototypedIngredientAlternatives<ItemStack, Integer> getPrototypesFor(ItemStack itemStack) {
            return new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)itemStack, (Object)this.flags)));
        }
    }

    public static interface IPrototypeHandler {
        public IPrototypedIngredientAlternatives<ItemStack, Integer> getPrototypesFor(ItemStack var1);
    }
}

