/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeNbt
extends ValueTypeBase<ValueNbt>
implements IValueTypeNullable<ValueNbt>,
IValueTypeNamed<ValueNbt> {
    public ValueTypeNbt() {
        super("nbt", Helpers.RGBToInt((int)0, (int)170, (int)170), TextFormatting.DARK_AQUA, ValueNbt.class);
    }

    @Override
    public ValueNbt getDefault() {
        return ValueNbt.of();
    }

    @Override
    public ITextComponent toCompactString(ValueNbt value) {
        return new StringTextComponent(this.toString(value));
    }

    @Override
    public INBT serialize(ValueNbt value) {
        CompoundNBT tag = new CompoundNBT();
        if (value.getRawValue().isPresent()) {
            tag.func_218657_a("v", (INBT)value.getRawValue().get());
        }
        return tag;
    }

    @Override
    public ValueNbt deserialize(INBT value) {
        if (value instanceof CompoundNBT && ((CompoundNBT)value).func_74764_b("v")) {
            return ValueNbt.of(((CompoundNBT)value).func_74781_a("v"));
        }
        return ValueNbt.of();
    }

    @Override
    public String toString(ValueNbt value) {
        return value.getRawValue().map(Object::toString).orElse("");
    }

    @Override
    public ValueNbt parseString(String value) throws EvaluationException {
        if (value.isEmpty()) {
            return ValueNbt.of();
        }
        try {
            return ValueNbt.of(new JsonToNBT(new StringReader(value)).func_193610_d());
        }
        catch (CommandSyntaxException e) {
            throw new EvaluationException((ITextComponent)new StringTextComponent(e.getMessage()));
        }
    }

    @Override
    public boolean isNull(ValueNbt a) {
        return !a.getRawValue().isPresent();
    }

    public INBT filterBlacklistedTags(INBT tag) {
        if (tag instanceof CompoundNBT) {
            boolean copied = false;
            CompoundNBT compountTag = (CompoundNBT)tag;
            for (String key : GeneralConfig.nbtTagBlacklist) {
                if (!compountTag.func_74764_b(key)) continue;
                if (!copied) {
                    copied = true;
                    compountTag = compountTag.func_74737_b();
                }
                compountTag.func_82580_o(key);
            }
            return compountTag;
        }
        return tag;
    }

    @Override
    public String getName(ValueNbt value) {
        return this.toCompactString(value).getString();
    }

    public static class ValueNbt
    extends ValueOptionalBase<INBT> {
        private ValueNbt(INBT value) {
            super(ValueTypes.NBT, value);
        }

        @Override
        @Nullable
        protected INBT preprocessValue(@Nullable INBT value) {
            if (value != null) {
                return ValueTypes.NBT.filterBlacklistedTags(value);
            }
            return null;
        }

        public static ValueNbt of(@Nullable INBT value) {
            return new ValueNbt(value);
        }

        public static ValueNbt of(Optional<INBT> value) {
            return ValueNbt.of(value.orElse(null));
        }

        public static ValueNbt of() {
            return ValueNbt.of((INBT)null);
        }

        @Override
        protected boolean isEqual(INBT a, INBT b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return "ValueTypeNbt.ValueNbt()";
        }
    }
}

