/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityBase;

public abstract class ValueTypeListProxyEntityCapability<C, T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyEntityBase<T, V> {
    private final Capability<C> capability;
    private Direction side;

    public ValueTypeListProxyEntityCapability(ResourceLocation name, T valueType, World world, Entity entity, Capability<C> capability, @Nullable Direction side) {
        super(name, valueType, world, entity);
        this.capability = capability;
        this.side = side;
    }

    protected LazyOptional<C> getCapability() {
        Entity e = this.getEntity();
        if (e != null) {
            return e.getCapability(this.capability, this.side);
        }
        return LazyOptional.empty();
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundNBT tag) {
        super.writeGeneratedFieldsToNBT(tag);
        if (this.side != null) {
            tag.func_74768_a("side", this.side.ordinal());
        }
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundNBT tag) {
        super.readGeneratedFieldsFromNBT(tag);
        if (tag.func_150297_b("side", 3)) {
            this.side = Direction.values()[tag.func_74762_e("side")];
        }
    }
}

