/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Iterables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;

public class ValueObjectTypeRecipe
extends ValueObjectTypeBase<ValueRecipe>
implements IValueTypeNamed<ValueRecipe>,
IValueTypeNullable<ValueRecipe> {
    public ValueObjectTypeRecipe() {
        super("recipe", ValueRecipe.class);
    }

    @Override
    public ValueRecipe getDefault() {
        return ValueRecipe.of(null);
    }

    @Override
    public ITextComponent toCompactString(ValueRecipe value) {
        if (value.getRawValue().isPresent()) {
            IRecipeDefinition recipe = (IRecipeDefinition)value.getRawValue().get();
            StringTextComponent sb = new StringTextComponent("");
            sb.func_150257_a(ValueObjectTypeIngredients.ingredientsToTextComponent(recipe.getOutput()));
            sb.func_150257_a((ITextComponent)new StringTextComponent(" <- "));
            boolean first = true;
            for (IngredientComponent component : recipe.getInputComponents()) {
                IIngredientComponentHandler handler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                for (IPrototypedIngredientAlternatives instances : recipe.getInputs(component)) {
                    IPrototypedIngredient prototypedIngredient = (IPrototypedIngredient)Iterables.getFirst((Iterable)instances.getAlternatives(), null);
                    Object v = prototypedIngredient == null ? handler.getValueType().getDefault() : handler.toValue(prototypedIngredient.getPrototype());
                    if (!first) {
                        sb.func_150257_a((ITextComponent)new StringTextComponent(", "));
                    } else {
                        first = false;
                    }
                    sb.func_150257_a(handler.toCompactString(v));
                }
            }
            return sb;
        }
        return new StringTextComponent("");
    }

    @Override
    public INBT serialize(ValueRecipe value) {
        if (!value.getRawValue().isPresent()) {
            return new CompoundNBT();
        }
        return IRecipeDefinition.serialize((IRecipeDefinition)((IRecipeDefinition)value.getRawValue().get()));
    }

    @Override
    public ValueRecipe deserialize(INBT value) {
        if (value.func_74732_a() == 0 || value.func_74732_a() == 10 && ((CompoundNBT)value).isEmpty()) {
            return ValueRecipe.of(null);
        }
        try {
            return ValueRecipe.of((IRecipeDefinition)IRecipeDefinition.deserialize((CompoundNBT)((CompoundNBT)value)));
        }
        catch (IllegalArgumentException e) {
            return ValueRecipe.of(null);
        }
    }

    @Override
    public String getName(ValueRecipe a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueRecipe a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeRecipeLPElement();
    }

    public static class ValueRecipe
    extends ValueOptionalBase<IRecipeDefinition> {
        private ValueRecipe(IRecipeDefinition recipe) {
            super(ValueTypes.OBJECT_RECIPE, recipe);
        }

        public static ValueRecipe of(IRecipeDefinition recipe) {
            return new ValueRecipe(recipe);
        }

        @Override
        protected boolean isEqual(IRecipeDefinition a, IRecipeDefinition b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeRecipe.ValueRecipe()";
        }
    }
}

