/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeBlock
extends ValueObjectTypeBase<ValueBlock>
implements IValueTypeNamed<ValueBlock>,
IValueTypeUniquelyNamed<ValueBlock>,
IValueTypeNullable<ValueBlock> {
    public ValueObjectTypeBlock() {
        super("block", ValueBlock.class);
    }

    public static ITextComponent getBlockDisplayNameUsSafe(BlockState blockState) throws NoSuchMethodException {
        return blockState.func_177230_c().func_200291_n();
    }

    public static ITextComponent getBlockkDisplayNameSafe(BlockState blockState) {
        try {
            return ValueObjectTypeBlock.getBlockDisplayNameUsSafe(blockState);
        }
        catch (NoSuchMethodException e) {
            return new TranslationTextComponent(blockState.func_177230_c().func_149739_a(), new Object[0]);
        }
    }

    @Override
    public ValueBlock getDefault() {
        return ValueBlock.of(Blocks.field_150350_a.func_176223_P());
    }

    @Override
    public ITextComponent toCompactString(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            ItemStack itemStack = BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
            if (!itemStack.func_190926_b()) {
                return ValueObjectTypeItemStack.getItemStackDisplayNameSafe(itemStack);
            }
            return ValueObjectTypeBlock.getBlockkDisplayNameSafe(blockState);
        }
        return new StringTextComponent("");
    }

    @Override
    public INBT serialize(ValueBlock value) {
        if (!value.getRawValue().isPresent()) {
            return new CompoundNBT();
        }
        return BlockHelpers.serializeBlockState((BlockState)((BlockState)value.getRawValue().get()));
    }

    @Override
    public ValueBlock deserialize(INBT value) {
        if (value.func_74732_a() == 0 || value.func_74732_a() == 10 && ((CompoundNBT)value).isEmpty()) {
            return ValueBlock.of(Blocks.field_150350_a.func_176223_P());
        }
        return ValueBlock.of(BlockHelpers.deserializeBlockState((INBT)value));
    }

    @Override
    public String getName(ValueBlock a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueBlock a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueBlock>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueBlock>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public ITextComponent validate(ItemStack itemStack) {
                if (!itemStack.func_190926_b() && !(itemStack.func_77973_b() instanceof BlockItem)) {
                    return new TranslationTextComponent("valuetype.integrateddynamics.error.block.no_block", new Object[0]);
                }
                return null;
            }

            @Override
            public ValueBlock getValue(ItemStack itemStack) {
                return ValueBlock.of(itemStack.func_190926_b() ? Blocks.field_150350_a.func_176223_P() : BlockHelpers.getBlockStateFromItemStack((ItemStack)itemStack));
            }
        });
    }

    @Override
    public String getUniqueName(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            return blockState.func_177230_c().getRegistryName().toString();
        }
        return "";
    }

    public static class ValueBlock
    extends ValueOptionalBase<BlockState> {
        private ValueBlock(BlockState blockState) {
            super(ValueTypes.OBJECT_BLOCK, blockState);
        }

        public static ValueBlock of(BlockState blockState) {
            return new ValueBlock(blockState);
        }

        @Override
        protected boolean isEqual(BlockState a, BlockState b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeBlock.ValueBlock()";
        }
    }
}

