/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.core.evaluate.operator.CurriedOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class ValueHelpers {
    public static IValueType[] from(IVariable ... variables) {
        IValueType[] valueTypes = new IValueType[variables.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IVariable variable = variables[i];
            valueTypes[i] = variable == null ? null : variable.getType();
        }
        return valueTypes;
    }

    public static IValueType<?>[] from(IVariableFacade ... variableFacades) {
        IValueType[] valueTypes = new IValueType[variableFacades.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IVariableFacade variableFacade = variableFacades[i];
            valueTypes[i] = variableFacade == null ? null : variableFacade.getOutputType();
        }
        return valueTypes;
    }

    public static ITextComponent[] from(IValueType<?> ... valueTypes) {
        ITextComponent[] names = new ITextComponent[valueTypes.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IValueType<?> valueType = valueTypes[i];
            names[i] = new TranslationTextComponent(valueType.getTranslationKey(), new Object[0]);
        }
        return names;
    }

    public static boolean areValuesEqual(@Nullable IValue v1, @Nullable IValue v2) {
        return v1 == null && v2 == null || v1 != null && v2 != null && v1.equals(v2);
    }

    public static boolean correspondsTo(IValueType t1, IValueType t2) {
        return t1.correspondsTo(t2) || t2.correspondsTo(t1);
    }

    public static IValue evaluateOperator(IOperator operator, IValue ... values) throws EvaluationException {
        IVariable[] variables = new IVariable[values.length];
        for (int i = 0; i < variables.length; ++i) {
            IValue value = values[i];
            variables[i] = new Variable<IValue>(value.getType(), value);
        }
        return ValueHelpers.evaluateOperator(operator, variables);
    }

    public static IValue evaluateOperator(IOperator operator, IVariable ... variables) throws EvaluationException {
        int requiredLength = operator.getRequiredInputLength();
        if (requiredLength == variables.length) {
            return operator.evaluate(variables);
        }
        if (variables.length > requiredLength) {
            IVariable[] acceptableVariables = (IVariable[])ArrayUtils.subarray((Object[])variables, (int)0, (int)requiredLength);
            IVariable[] remainingVariables = (IVariable[])ArrayUtils.subarray((Object[])variables, (int)requiredLength, (int)variables.length);
            IValue result = ValueHelpers.evaluateOperator(operator, acceptableVariables);
            if (result.getType() != ValueTypes.OPERATOR) {
                throw new EvaluationException((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.error.currying_overflow", new Object[]{new TranslationTextComponent(operator.getTranslationKey(), new Object[0]), requiredLength, variables.length, new TranslationTextComponent(result.getType().getTranslationKey(), new Object[0])}));
            }
            IOperator nextOperator = ((ValueTypeOperator.ValueOperator)result).getRawValue();
            return ValueHelpers.evaluateOperator(nextOperator, remainingVariables);
        }
        return ValueTypeOperator.ValueOperator.of(new CurriedOperator(operator, variables));
    }

    public static INBT serializeRaw(IValue value) {
        return value.getType().serialize(value);
    }

    public static CompoundNBT serialize(IValue value) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("valueType", value.getType().getUniqueName().toString());
        tag.func_218657_a("value", ValueHelpers.serializeRaw(value));
        return tag;
    }

    public static IValue deserialize(CompoundNBT tag) {
        IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(tag.func_74779_i("valueType")));
        if (valueType == null) {
            return null;
        }
        return ValueHelpers.deserializeRaw(valueType, tag.func_74781_a("value"));
    }

    public static <T extends IValue> T deserializeRaw(IValueType<T> valueType, INBT valueString) {
        return valueType.deserialize(valueString);
    }

    public static <T extends IValue> String toString(T value) {
        return value.getType().toString(value);
    }

    public static <T extends IValue> T parseString(IValueType<T> valueType, String value) throws EvaluationException {
        return valueType.parseString(value);
    }

    public static void validatePredicateOutput(IOperator predicate, IValue result) throws EvaluationException {
        if (!(result instanceof ValueTypeBoolean.ValueBoolean)) {
            TranslationTextComponent error = new TranslationTextComponent("operator.integrateddynamics.error.wrong_predicate", new Object[]{predicate.getLocalizedNameFull(), new TranslationTextComponent(result.getType().getTranslationKey(), new Object[0]), ValueTypes.BOOLEAN});
            throw new EvaluationException((ITextComponent)error);
        }
    }

    public static Pair<ITextComponent, Integer> getSafeReadableValue(@Nullable IVariable variable) {
        StringTextComponent readValue = new StringTextComponent("");
        int readValueColor = 0;
        if (!NetworkHelpers.shouldWork()) {
            readValue = new StringTextComponent("SAFE-MODE");
        } else if (variable != null) {
            try {
                Object value = variable.getValue();
                readValue = value.getType().toCompactString(value);
                readValueColor = value.getType().getDisplayColor();
            }
            catch (NullPointerException | PartStateException | EvaluationException e) {
                readValue = new StringTextComponent("ERROR");
                readValueColor = Helpers.RGBToInt((int)255, (int)0, (int)0);
            }
        }
        return Pair.of((Object)readValue, (Object)readValueColor);
    }
}

