/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.expression;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.IExpression;
import org.cyclops.integrateddynamics.api.evaluate.expression.ILazyExpressionValueCache;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;

public class LazyExpression<V extends IValue>
extends VariableAdapter<V>
implements IExpression<V> {
    private final int id;
    private final IOperator op;
    private final IVariable[] input;
    private final ILazyExpressionValueCache valueCache;
    private boolean errored = false;

    public LazyExpression(int id, IOperator op, IVariable[] input, ILazyExpressionValueCache valueCache) {
        this.id = id;
        this.op = op;
        this.input = input;
        this.valueCache = valueCache;
        valueCache.removeValue(id);
    }

    @Override
    public IValue evaluate() throws EvaluationException {
        if (this.valueCache.hasValue(this.id)) {
            return this.valueCache.getValue(this.id);
        }
        IValue value = this.op.evaluate(this.input);
        for (IVariable inputVariable : this.input) {
            inputVariable.addInvalidationListener(this);
        }
        this.valueCache.setValue(this.id, value);
        return value;
    }

    @Override
    public boolean hasErrored() {
        return this.errored;
    }

    @Override
    public IValueType<V> getType() {
        return this.op.getConditionalOutputType(this.input);
    }

    @Override
    public V getValue() throws EvaluationException {
        IValue value;
        try {
            value = this.evaluate();
        }
        catch (EvaluationException e) {
            this.errored = true;
            throw e;
        }
        try {
            return (V)value;
        }
        catch (ClassCastException e) {
            this.errored = true;
            throw new EvaluationException((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.error.wrong_type_output", new Object[]{this.op, new TranslationTextComponent(value.getType().getTranslationKey(), new Object[0]), new TranslationTextComponent(this.op.getOutputType().getTranslationKey(), new Object[0])}));
        }
    }

    @Override
    public void invalidate() {
        this.valueCache.removeValue(this.id);
        super.invalidate();
    }

    public IOperator getOperator() {
        return this.op;
    }

    public IVariable[] getInput() {
        return this.input;
    }
}

