/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelProvider;
import org.cyclops.integrateddynamics.core.client.model.ModelHelpers;
import org.cyclops.integrateddynamics.core.client.model.VariableModelBaked;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;

public class VariableModel
implements IUnbakedModel,
IModelGeometry<VariableModel> {
    private final BlockModel base;

    public VariableModel(BlockModel base) {
        this.base = base;
    }

    public void loadSubModels(ModelLoader modelLoader) {
        for (IVariableModelProvider<? extends IVariableModelProvider.IBakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            provider.loadModels(modelLoader);
        }
    }

    public static void addAdditionalModels(ImmutableSet.Builder<ResourceLocation> builder) {
        for (IVariableModelProvider<? extends IVariableModelProvider.IBakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            builder.addAll(provider.getDependencies());
        }
    }

    public Collection<ResourceLocation> func_187965_e() {
        if (this.base.getParentLocation() == null || this.base.getParentLocation().func_110623_a().startsWith("builtin/")) {
            return Collections.emptyList();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.base.getParentLocation());
        VariableModel.addAdditionalModels((ImmutableSet.Builder<ResourceLocation>)builder);
        return builder.build();
    }

    public Collection<Material> func_225614_a_(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        this.base.field_178315_d = ModelHelpers.MODEL_GENERATED;
        HashSet textures = Sets.newHashSet((Object[])new Material[]{this.base.func_228816_c_("particle")});
        if (this.base.func_178310_f() == ModelBakery.field_177606_o) {
            ItemModelGenerator.field_178398_a.forEach(p_228814_2_ -> textures.add(this.base.func_228816_c_(p_228814_2_)));
        }
        for (Either texture : this.base.field_178318_c.values()) {
            texture.ifLeft(textures::add);
        }
        return textures;
    }

    @Nullable
    public IBakedModel func_225613_a_(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform transform, ResourceLocation location) {
        Material textureName = this.base.func_228816_c_("layer0");
        BlockModel itemModel = ModelHelpers.MODEL_GENERATOR.func_209579_a(spriteGetter, this.base);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)itemModel.customData, itemModel.getOverrides(bakery, itemModel, spriteGetter));
        itemModel.field_178318_c.put("layer0", Either.left((Object)textureName));
        TextureAtlasSprite textureAtlasSprite = spriteGetter.apply(textureName);
        builder.func_177646_a(textureAtlasSprite);
        for (BakedQuad bakedQuad : ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)textureAtlasSprite, (TransformationMatrix)transform.func_225615_b_())) {
            builder.func_177648_a(bakedQuad);
        }
        IBakedModel baseModel = builder.func_177645_b();
        VariableModelBaked bakedModel = new VariableModelBaked(baseModel);
        for (IVariableModelProvider<? extends IVariableModelProvider.IBakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            bakedModel.setSubModels(provider, provider.bakeOverlayModels(bakery, spriteGetter, transform, location));
        }
        return bakedModel;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        return this.func_225613_a_(bakery, spriteGetter, modelTransform, modelLocation);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.func_225614_a_(modelGetter, missingTextureErrors);
    }
}

