/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerScreenPartSettings<T extends ContainerPartSettings>
extends ContainerScreenExtended<T> {
    private WidgetNumberField numberFieldUpdateInterval = null;
    private WidgetNumberField numberFieldPriority = null;
    private WidgetNumberField numberFieldChannel = null;
    private WidgetTextFieldDropdown<Direction> dropdownFieldSide = null;
    private List<SideDropdownEntry> dropdownEntries;

    public ContainerScreenPartSettings(T container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
    }

    protected void onSave() {
        try {
            if (this.isFieldSideEnabled()) {
                Direction selectedSide = this.dropdownFieldSide.getSelectedDropdownPossibility() == null ? null : this.dropdownFieldSide.getSelectedDropdownPossibility().getValue();
                int side = selectedSide != null && selectedSide != this.getDefaultSide() ? selectedSide.ordinal() : -1;
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartSettings)this.func_212873_a_()).getLastSideValueId(), (int)side);
            }
            if (this.isFieldUpdateIntervalEnabled()) {
                int updateInterval = this.numberFieldUpdateInterval.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartSettings)this.func_212873_a_()).getLastUpdateValueId(), (int)updateInterval);
            }
            if (this.isFieldPriorityEnabled()) {
                int priority = this.numberFieldPriority.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartSettings)this.func_212873_a_()).getLastPriorityValueId(), (int)priority);
            }
            if (this.isFieldChannelEnabled()) {
                int channel = this.numberFieldChannel.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartSettings)this.func_212873_a_()).getLastChannelValueId(), (int)channel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/part_settings.png");
    }

    protected Direction getCurrentSide() {
        return ((ContainerPartSettings)this.func_212873_a_()).getTarget().getTarget().getSide();
    }

    protected Direction getDefaultSide() {
        return ((ContainerPartSettings)this.func_212873_a_()).getTarget().getCenter().getSide().func_176734_d();
    }

    protected String getSideText(Direction side) {
        return side.func_176610_l().toLowerCase(Locale.ENGLISH);
    }

    public void init() {
        super.init();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        if (this.isFieldSideEnabled()) {
            this.dropdownEntries = Arrays.stream(Direction.values()).map(x$0 -> new SideDropdownEntry((Direction)x$0)).collect(Collectors.toList());
            this.dropdownFieldSide = new WidgetTextFieldDropdown(this.font, this.field_147003_i + 106, this.field_147009_r + this.getFieldSideY(), 70, 14, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.side", (Object[])new Object[0]), true, Sets.newHashSet(this.dropdownEntries));
            this.setSideInDropdownField(this.getCurrentSide());
            this.dropdownFieldSide.func_146203_f(15);
            this.dropdownFieldSide.func_146189_e(true);
            this.dropdownFieldSide.func_146193_g(0xFFFFFF);
            this.dropdownFieldSide.func_146205_d(true);
        }
        if (this.isFieldUpdateIntervalEnabled()) {
            this.numberFieldUpdateInterval = new WidgetNumberField(this.font, this.field_147003_i + 106, this.field_147009_r + this.getFieldUpdateIntervalY(), 70, 14, true, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.update_interval", (Object[])new Object[0]), true);
            this.numberFieldUpdateInterval.func_146203_f(15);
            this.numberFieldUpdateInterval.func_146189_e(true);
            this.numberFieldUpdateInterval.func_146193_g(0xFFFFFF);
            this.numberFieldUpdateInterval.func_146205_d(true);
            this.numberFieldUpdateInterval.setMinValue(((ContainerPartSettings)this.field_147002_h).getLastMinUpdateValue());
        }
        if (this.isFieldPriorityEnabled()) {
            this.numberFieldPriority = new WidgetNumberField(this.font, this.field_147003_i + 106, this.field_147009_r + this.getFieldPriorityY(), 70, 14, true, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.priority", (Object[])new Object[0]), true);
            this.numberFieldPriority.setPositiveOnly(false);
            this.numberFieldPriority.func_146203_f(15);
            this.numberFieldPriority.func_146189_e(true);
            this.numberFieldPriority.func_146193_g(0xFFFFFF);
            this.numberFieldPriority.func_146205_d(true);
        }
        if (this.isFieldChannelEnabled()) {
            this.numberFieldChannel = new WidgetNumberField(this.font, this.field_147003_i + 106, this.field_147009_r + this.getFieldChannelY(), 70, 14, true, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.channel", (Object[])new Object[0]), true);
            this.numberFieldChannel.setPositiveOnly(false);
            this.numberFieldChannel.func_146203_f(15);
            this.numberFieldChannel.func_146189_e(true);
            this.numberFieldChannel.func_146193_g(0xFFFFFF);
            this.numberFieldChannel.func_146205_d(true);
            this.numberFieldChannel.func_146184_c(this.isChannelEnabled());
        }
        String save = L10NHelpers.localize((String)"gui.integrateddynamics.button.save", (Object[])new Object[0]);
        this.addButton((Widget)new ButtonText(this.field_147003_i + 178, this.field_147009_r + 8, this.font.func_78256_a(save) + 6, 16, save, save, this.createServerPressable("button_save", b -> this.onSave()), true));
        this.refreshValues();
    }

    protected int getFieldSideY() {
        return 9;
    }

    protected int getFieldUpdateIntervalY() {
        return 34;
    }

    protected int getFieldPriorityY() {
        return 59;
    }

    protected int getFieldChannelY() {
        return 84;
    }

    protected boolean isFieldSideEnabled() {
        return true;
    }

    protected boolean isFieldUpdateIntervalEnabled() {
        return true;
    }

    protected boolean isFieldPriorityEnabled() {
        return true;
    }

    protected boolean isFieldChannelEnabled() {
        return true;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!(this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.charTyped(typedChar, keyCode) || this.isFieldPriorityEnabled() && this.numberFieldPriority.charTyped(typedChar, keyCode) || this.isFieldChannelEnabled() && this.numberFieldChannel.charTyped(typedChar, keyCode) || this.isFieldSideEnabled() && this.dropdownFieldSide.charTyped(typedChar, keyCode))) {
            return super.charTyped(typedChar, keyCode);
        }
        return true;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.isFieldSideEnabled() && this.dropdownFieldSide.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldPriorityEnabled() && this.numberFieldPriority.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.isFieldChannelEnabled() && this.numberFieldChannel.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isFieldSideEnabled() && this.dropdownFieldSide.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldPriorityEnabled() && this.numberFieldPriority.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isFieldChannelEnabled() && this.numberFieldChannel.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.isFieldUpdateIntervalEnabled()) {
            this.font.func_211126_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.update_interval", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.getFieldUpdateIntervalY() + 3), Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.numberFieldUpdateInterval.render(mouseX, mouseY, partialTicks);
        }
        if (this.isFieldPriorityEnabled()) {
            this.font.func_211126_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.priority", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.getFieldPriorityY() + 3), Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.numberFieldPriority.render(mouseX, mouseY, partialTicks);
        }
        if (this.isFieldChannelEnabled()) {
            this.font.func_211126_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.channel", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.getFieldChannelY() + 3), this.isChannelEnabled() ? Helpers.RGBToInt((int)0, (int)0, (int)0) : Helpers.RGBToInt((int)100, (int)100, (int)100));
            this.numberFieldChannel.render(mouseX, mouseY, partialTicks);
        }
        if (this.isFieldSideEnabled()) {
            this.font.func_211126_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.side", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.getFieldSideY() + 3), Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.dropdownFieldSide.render(mouseX, mouseY, partialTicks);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (!this.isChannelEnabled()) {
            GuiHelpers.renderTooltip((ContainerScreen)this, (int)8, (int)87, (int)100, (int)20, (int)mouseX, (int)mouseY, () -> Lists.newArrayList((Iterable)new TranslationTextComponent("gui.integrateddynamics.partsettings.channel.disabledinfo", new Object[0])));
        }
    }

    protected boolean isChannelEnabled() {
        return GeneralConfig.energyConsumptionMultiplier > 0;
    }

    protected int getBaseXSize() {
        return 214;
    }

    protected int getBaseYSize() {
        return 191;
    }

    protected void setSideInDropdownField(Direction side) {
        this.dropdownFieldSide.selectPossibility(this.dropdownEntries.get(side.ordinal()));
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        if (this.isFieldSideEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastSideValueId()) {
            int side = ((ContainerPartSettings)this.func_212873_a_()).getLastSideValue();
            this.setSideInDropdownField(side == -1 ? this.getDefaultSide() : Direction.values()[side]);
        }
        if (this.isFieldUpdateIntervalEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastUpdateValueId()) {
            this.numberFieldUpdateInterval.func_146180_a(Integer.toString(((ContainerPartSettings)this.func_212873_a_()).getLastUpdateValue()));
        }
        if (this.isFieldUpdateIntervalEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastMinUpdateValueId()) {
            this.numberFieldUpdateInterval.setMinValue(((ContainerPartSettings)this.func_212873_a_()).getLastMinUpdateValue());
        }
        if (this.isFieldPriorityEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastPriorityValueId()) {
            this.numberFieldPriority.func_146180_a(Integer.toString(((ContainerPartSettings)this.func_212873_a_()).getLastPriorityValue()));
        }
        if (this.isFieldChannelEnabled() && valueId == ((ContainerPartSettings)this.func_212873_a_()).getLastChannelValueId()) {
            this.numberFieldChannel.func_146180_a(Integer.toString(((ContainerPartSettings)this.func_212873_a_()).getLastChannelValue()));
        }
    }

    public class SideDropdownEntry
    implements IDropdownEntry<Direction> {
        private final Direction side;

        public SideDropdownEntry(Direction side) {
            this.side = side;
        }

        @Override
        public String getMatchString() {
            return ContainerScreenPartSettings.this.getSideText(this.side);
        }

        @Override
        public String getDisplayString() {
            return (ContainerScreenPartSettings.this.getDefaultSide() == this.side ? TextFormatting.YELLOW : "") + this.getMatchString();
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return Collections.emptyList();
        }

        @Override
        public Direction getValue() {
            return this.side;
        }
    }
}

