/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.part;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.part.PartOverlayRendererBase;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.part.PartTypePanelDisplay;

@OnlyIn(value=Dist.CLIENT)
public class DisplayPartOverlayRenderer
extends PartOverlayRendererBase {
    public static final float MAX = 12.5f;
    protected static final float pixel = 0.0625f;

    @Override
    protected void setMatrixOrientation(MatrixStack matrixStack, Direction direction) {
        super.setMatrixOrientation(matrixStack, direction);
        float translateX = -1.0f - (float)direction.func_82601_c() + 0.25f;
        float translateY = 1.0f - (float)direction.func_96559_d() - 0.25f;
        float translateZ = (float)direction.func_82599_e() - 0.0625f + 0.0025f;
        if (direction == Direction.NORTH) {
            translateZ += 1.0f;
        } else if (direction == Direction.EAST) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.SOUTH) {
            translateX += 1.0f;
        } else if (direction == Direction.UP) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.DOWN) {
            translateX += 1.0f;
            translateY -= 1.0f;
        }
        matrixStack.func_227861_a_((double)translateX, (double)translateY, (double)translateZ);
    }

    @Override
    public void renderPartOverlay(TileEntityRendererDispatcher rendererDispatcher, IPartContainer partContainer, Direction direction, IPartType partType, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        BlockPos pos = partContainer.getPosition().getBlockPos();
        if (!this.shouldRender(pos)) {
            return;
        }
        ClientPlayerEntity renderEntity = Minecraft.func_71410_x().field_71439_g;
        float distanceFactor = (float)(((double)this.getMaxRenderDistance() - renderEntity.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) / 5.0);
        float distanceAlpha = Math.min(1.0f, distanceFactor);
        if (distanceAlpha < 0.05f) {
            distanceAlpha = 0.05f;
        }
        matrixStack.func_227860_a_();
        float scale = 0.04f;
        this.setMatrixOrientation(matrixStack, direction);
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
        IPartState partStateUnsafe = partContainer.getPartState(direction);
        if (!(partStateUnsafe instanceof PartTypePanelDisplay.State)) {
            this.drawError(rendererDispatcher, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, distanceAlpha);
        } else {
            PartTypePanelDisplay.State partState = (PartTypePanelDisplay.State)partStateUnsafe;
            if (partState.getFacingRotation() == null) {
                this.drawError(rendererDispatcher, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, distanceAlpha);
                return;
            }
            int rotation = partState.getFacingRotation().ordinal() - 2;
            matrixStack.func_227861_a_(6.0, 6.0, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)rotation));
            matrixStack.func_227861_a_(-6.0, -6.0, 0.0);
            IValue value = partState.getDisplayValue();
            if (value != null && partState.isEnabled()) {
                IValueType valueType = value.getType();
                IValueTypeWorldRenderer renderer = ValueTypeWorldRenderers.REGISTRY.getRenderer(valueType);
                if (renderer == null) {
                    renderer = ValueTypeWorldRenderers.DEFAULT;
                }
                renderer.renderValue(rendererDispatcher, partContainer, direction, partType, value, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, distanceAlpha);
            } else if (!partState.getInventory().func_191420_l()) {
                this.drawError(rendererDispatcher, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, distanceAlpha);
            }
        }
        matrixStack.func_227865_b_();
    }

    protected void drawError(TileEntityRendererDispatcher rendererDispatcher, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay, float distanceAlpha) {
        Images.ERROR.drawWorldWithAlpha(rendererDispatcher.field_147553_e, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, 12.5f, 12.5f, distanceAlpha);
    }
}

