/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.helper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import svenhjol.meson.helper.WorldHelper;

public class PlayerHelper {
    public static boolean addOrDropStack(PlayerEntity player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
            return false;
        }
        return true;
    }

    public static void damageHeldItem(PlayerEntity player, Hand hand, ItemStack stack, int damage) {
        stack.func_222118_a(damage, (LivingEntity)player, p -> player.func_213334_d(hand));
    }

    public static ImmutableList<NonNullList<ItemStack>> getInventories(PlayerEntity player) {
        PlayerInventory inventory = player.field_71071_by;
        return ImmutableList.of((Object)inventory.field_70462_a, (Object)inventory.field_70460_b, (Object)inventory.field_184439_c);
    }

    public static void doLightningNearPlayer(PlayerEntity player) {
        int dist = 24;
        World world = player.field_70170_p;
        Random rand = world.field_73012_v;
        if (!WorldHelper.canSeeSky((IWorld)world, player.func_180425_c())) {
            return;
        }
        BlockPos pos = player.func_180425_c().func_177982_a(-(dist / 2) + rand.nextInt(dist), 0, -(dist / 2) + rand.nextInt(dist));
        ((ServerWorld)world).func_217468_a(new LightningBoltEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, false));
    }

    public static boolean isCrouching(PlayerEntity player) {
        return player.func_213453_ef();
    }

    public static void setHeldItem(PlayerEntity player, Hand hand, ItemStack item) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190916_E() == 1) {
            player.func_184611_a(hand, item);
        } else {
            stack.func_190918_g(1);
            if (stack.func_190916_E() == 0) {
                player.func_184611_a(hand, item);
            } else {
                PlayerHelper.addOrDropStack(player, item);
            }
        }
    }

    public static boolean spawnEntityNearPlayer(PlayerEntity player, MobEntity mob, BiConsumer<MobEntity, BlockPos> onSpawn) {
        boolean spawned = false;
        int range = 8;
        int tries = 8;
        BlockPos pp = player.func_180425_c();
        World world = player.field_70170_p;
        Random rand = world.field_73012_v;
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        for (int y = pp.func_177956_o() + range * 2; y > 0; --y) {
            block1: for (int i = range; i > 1; --i) {
                for (int c = 1; c < tries; ++c) {
                    boolean areaIsValid;
                    BlockPos p = new BlockPos(pp.func_177958_n() + rand.nextInt(i), y, pp.func_177952_p() + rand.nextInt(i));
                    BlockPos floor = p.func_177977_b();
                    BlockPos above = p.func_177984_a();
                    boolean bl = areaIsValid = WorldHelper.isSolidishBlock(world, floor) && WorldHelper.isAirBlock(world, p) && WorldHelper.isAirBlock(world, p);
                    if (areaIsValid) {
                        valid.add(above);
                    }
                    if (valid.size() > 2) continue block1;
                }
            }
        }
        if (valid.isEmpty()) {
            return false;
        }
        BlockPos spawnPos = (BlockPos)valid.get(rand.nextInt(valid.size()));
        mob.func_174828_a(spawnPos, 0.0f, 0.0f);
        mob.func_213386_a((IWorld)world, world.func_175649_E(spawnPos), SpawnReason.TRIGGERED, null, null);
        world.func_217376_c((Entity)mob);
        onSpawn.accept(mob, spawnPos);
        return true;
    }

    public static void teleport(PlayerEntity player, BlockPos pos, int dim) {
        PlayerHelper.teleport(player, pos, dim, p -> {});
    }

    public static void teleport(PlayerEntity player, BlockPos pos, int dim, Consumer<PlayerEntity> onTeleport) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        PlayerHelper.changeDimension(player, dim);
        player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
        BlockPos playerPos = player.func_180425_c();
        while (world.func_175623_d(playerPos.func_177977_b()) && playerPos.func_177956_o() > 0) {
            playerPos = playerPos.func_177977_b();
        }
        while (world.func_180495_p(playerPos).func_200132_m() || world.func_180495_p(playerPos.func_177984_a()).func_200132_m() && playerPos.func_177956_o() < 256) {
            playerPos = playerPos.func_177984_a();
        }
        player.func_70634_a((double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p());
        onTeleport.accept(player);
    }

    public static void teleportSurface(PlayerEntity player, BlockPos pos, int dim) {
        PlayerHelper.teleportSurface(player, pos, dim, p -> {});
    }

    public static void teleportSurface(PlayerEntity player, BlockPos pos, int dim, Consumer<PlayerEntity> onTeleport) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        PlayerHelper.teleport(player, pos, dim, p -> {
            for (int y = p.field_70170_p.func_217301_I(); y > 0; --y) {
                BlockPos pp = new BlockPos(p.func_180425_c().func_177958_n(), y, p.func_180425_c().func_177952_p());
                if (!p.field_70170_p.func_175623_d(pp) || p.field_70170_p.func_175623_d(pp.func_177977_b())) continue;
                p.func_70634_a((double)pp.func_177958_n(), (double)y, (double)pp.func_177952_p());
                onTeleport.accept((PlayerEntity)p);
                break;
            }
        });
    }

    public static void changeDimension(PlayerEntity player, int dim) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        DimensionType destination = DimensionType.func_186069_a((int)dim);
        if (destination == null) {
            return;
        }
        if (destination.func_186068_a() == player.field_71093_bK.func_186068_a()) {
            return;
        }
        if (!ForgeHooks.onTravelToDimension((Entity)player, (DimensionType)destination)) {
            return;
        }
        DimensionType dimensiontype = serverPlayer.field_71093_bK;
        ServerWorld serverworld = serverPlayer.field_71133_b.func_71218_a(dimensiontype);
        serverPlayer.field_71093_bK = destination;
        ServerWorld serverworld1 = serverPlayer.field_71133_b.func_71218_a(destination);
        WorldInfo worldinfo = serverPlayer.field_70170_p.func_72912_H();
        NetworkHooks.sendDimensionDataPacket((NetworkManager)serverPlayer.field_71135_a.field_147371_a, (ServerPlayerEntity)serverPlayer);
        serverPlayer.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination, WorldInfo.func_227498_c_((long)worldinfo.func_76063_b()), worldinfo.func_76067_t(), serverPlayer.field_71134_c.func_73081_b()));
        serverPlayer.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = serverPlayer.field_71133_b.func_184103_al();
        playerlist.func_187243_f(serverPlayer);
        serverworld.removeEntity((Entity)serverPlayer, true);
        serverPlayer.revive();
        BlockPos playerPos = serverPlayer.func_180425_c();
        double d0 = playerPos.func_177958_n();
        double d1 = playerPos.func_177956_o();
        double d2 = playerPos.func_177952_p();
        float f = serverPlayer.field_70125_A;
        float f1 = serverPlayer.field_70177_z;
        serverworld.func_217381_Z().func_76320_a("moving");
        double moveFactor = serverworld.func_201675_m().getMovementFactor() / serverworld1.func_201675_m().getMovementFactor();
        serverPlayer.func_70012_b(d0 *= moveFactor, d1, d2 *= moveFactor, f1, f);
        serverworld.func_217381_Z().func_76319_b();
        serverworld.func_217381_Z().func_76320_a("placing");
        double d7 = Math.min(-2.9999872E7, serverworld1.func_175723_af().func_177726_b() + 16.0);
        double d4 = Math.min(-2.9999872E7, serverworld1.func_175723_af().func_177736_c() + 16.0);
        double d5 = Math.min(2.9999872E7, serverworld1.func_175723_af().func_177728_d() - 16.0);
        double d6 = Math.min(2.9999872E7, serverworld1.func_175723_af().func_177733_e() - 16.0);
        d0 = MathHelper.func_151237_a((double)d0, (double)d7, (double)d5);
        d2 = MathHelper.func_151237_a((double)d2, (double)d4, (double)d6);
        serverPlayer.func_70012_b(d0, d1, d2, f1, f);
        serverworld.func_217381_Z().func_76319_b();
        serverPlayer.func_70029_a((World)serverworld1);
        serverworld1.func_217433_d(serverPlayer);
        serverPlayer.field_71135_a.func_147364_a((double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), f1, f);
        serverPlayer.field_71134_c.func_73080_a(serverworld1);
        serverPlayer.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(serverPlayer.field_71075_bZ));
        playerlist.func_72354_b(serverPlayer, serverworld1);
        playerlist.func_72385_f(serverPlayer);
        for (EffectInstance effectinstance : serverPlayer.func_70651_bq()) {
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(serverPlayer.func_145782_y(), effectinstance));
        }
        serverPlayer.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)serverPlayer, (DimensionType)dimensiontype, (DimensionType)destination);
    }
}

