/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.handler;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import svenhjol.meson.Meson;
import svenhjol.meson.iface.IMesonBlock;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    public static final Marker REGISTRY = MarkerManager.getMarker((String)"REGISTRY").addParents(new Marker[]{Meson.INTERNAL});

    public static void registerBlock(Block block, ResourceLocation res) {
        RegistryHandler.addRegisterable(block, res);
        if (block instanceof IMesonBlock) {
            RegistryHandler.addRegisterable(((IMesonBlock)block).getBlockItem(), res);
        }
    }

    public static void registerBrewingRecipe(Potion input, Item reagant, Potion output) {
        PotionBrewing.func_193357_a((Potion)input, (Item)reagant, (Potion)output);
    }

    public static void registerContainer(ContainerType<?> container, ResourceLocation res) {
        RegistryHandler.addRegisterable(container, res);
    }

    public static void registerEffect(Effect effect, ResourceLocation res) {
        RegistryHandler.addRegisterable(effect, res);
    }

    public static void registerEnchantment(Enchantment enchantment, ResourceLocation res) {
        RegistryHandler.addRegisterable(enchantment, res);
    }

    public static void registerEntity(EntityType<?> entity, ResourceLocation res) {
        RegistryHandler.addRegisterable(entity, res);
    }

    public static void registerFeature(Feature<?> feature, ResourceLocation res) {
        RegistryHandler.addRegisterable(feature, res);
    }

    public static void registerFeature(Feature<?> feature, Placement<?> placement, ResourceLocation res) {
        RegistryHandler.registerFeature(feature, res);
        RegistryHandler.addRegisterable(placement, res);
    }

    public static void registerItem(Item item, ResourceLocation res) {
        RegistryHandler.addRegisterable(item, res);
    }

    public static void registerParticleType(ParticleType<?> type, ResourceLocation res) {
        RegistryHandler.addRegisterable(type, res);
    }

    public static void registerPotion(Potion potion, ResourceLocation res) {
        RegistryHandler.addRegisterable(potion, res);
    }

    public static void registerSound(SoundEvent sound) {
        RegistryHandler.addRegisterable(sound, sound.getRegistryName());
    }

    public static void registerStructure(Structure<?> structure, ResourceLocation res) {
        RegistryHandler.addRegisterable(structure, res);
    }

    public static void registerStructurePiece(IStructurePieceType piece, ResourceLocation res) {
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)res, (Object)piece);
    }

    public static void registerTile(TileEntityType<?> tile, ResourceLocation res) {
        RegistryHandler.addRegisterable(tile, res);
    }

    public static void registerVillager(VillagerProfession profession, ResourceLocation res) {
        RegistryHandler.addRegisterable(profession, res);
    }

    public static void registerVillagerPointOfInterest(PointOfInterestType type, ResourceLocation res) {
        RegistryHandler.addRegisterable(type, res);
        PointOfInterestType.func_221052_a((PointOfInterestType)type);
    }

    @SubscribeEvent
    public static void onRegister(RegistryEvent.Register event) {
        IForgeRegistry registry = event.getRegistry();
        Class type = registry.getRegistrySuperType();
        Meson.instances.forEach((ns, instance) -> {
            ArrayListMultimap<Class<?>, Supplier<IForgeRegistryEntry<?>>> queued = instance.registerQueue;
            if (queued.containsKey((Object)type)) {
                List objects = queued.get((Object)type);
                for (Supplier supplier : objects) {
                    IForgeRegistryEntry obj = (IForgeRegistryEntry)supplier.get();
                    if (obj == null) {
                        Meson.LOG.error(REGISTRY, "Trying to register null object");
                        return;
                    }
                    try {
                        Meson.LOG.info(REGISTRY, "Registering to " + registry.getRegistryName() + " - " + obj.getRegistryName());
                        registry.register(obj);
                    }
                    catch (Exception e) {
                        Meson.LOG.error(REGISTRY, "Failed to register object " + obj + ": " + e.getMessage());
                    }
                }
                queued.removeAll((Object)type);
            }
        });
    }

    public static void addRegisterable(IForgeRegistryEntry<?> obj, ResourceLocation res) {
        String ns = ModLoadingContext.get().getActiveNamespace();
        Class type = obj.getRegistryType();
        if (res == null && obj.getRegistryName() == null) {
            Meson.LOG.error(REGISTRY, "Object has empty name: " + obj);
            return;
        }
        if (obj.getRegistryName() == null && res != null) {
            obj.setRegistryName(GameData.checkPrefix((String)res.toString(), (boolean)false));
        }
        try {
            Meson.getInstance((String)ns).registerQueue.put((Object)type, () -> obj);
            Meson.LOG.info(REGISTRY, "Queueing " + obj.getRegistryName());
        }
        catch (Exception e) {
            Meson.LOG.error("Failed to queue object " + obj.getRegistryName() + " " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }
}

