/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.handler;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import svenhjol.meson.MesonInstance;
import svenhjol.meson.iface.IMesonMessage;

public class PacketHandler {
    private int index = 0;
    private final MesonInstance instance;
    private final SimpleChannel channel;

    public PacketHandler(MesonInstance instance) {
        this(instance, "main", 1);
    }

    public PacketHandler(MesonInstance instance, String channelName, int protocol) {
        this.instance = instance;
        String s = String.valueOf(protocol);
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(instance.getId(), channelName)).clientAcceptedVersions(s::equals).serverAcceptedVersions(s::equals).networkProtocolVersion(() -> s).simpleChannel();
    }

    public <MSG> void register(Class<MSG> clazz, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        this.instance.log.debug("Registering message " + clazz + ", index " + this.index);
        this.channel.registerMessage(this.index, clazz, encoder, decoder, messageConsumer);
        ++this.index;
    }

    public void sendToAll(IMesonMessage msg) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            this.sendTo(msg, player);
        }
    }

    public void sendNonLocal(IMesonMessage msg, ServerPlayerEntity player) {
        if (player.field_71133_b.func_71262_S() || !player.func_146103_bH().getName().equals(player.field_71133_b.func_71214_G())) {
            this.channel.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void sendToServer(IMesonMessage msg) {
        this.channel.sendToServer((Object)msg);
    }

    public void sendTo(IMesonMessage msg, ServerPlayerEntity player) {
        if (!(player instanceof FakePlayer)) {
            this.channel.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

