/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.module;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.BiomeHelper;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="World", hasSubscriptions=true, description="Villages can spawn in swamps, jungles and bedrock-edition biomes.\nVillagers spawning in these villages will use their correct biome texture.")
public class MoreVillageBiomes
extends MesonModule {
    public static List<Biome> plainsBiomes = Arrays.asList(Biomes.field_76782_w, Biomes.field_76780_h, Biomes.field_185441_Q);
    public static List<Biome> taigaBiomes = Arrays.asList(Biomes.field_76784_u, Biomes.field_150584_S, Biomes.field_150579_T);

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        taigaBiomes.forEach(biome -> biome.func_226711_a_(Feature.field_214550_p.func_225566_b_((IFeatureConfig)new VillageConfig("village/taiga/town_centers", 6))));
        plainsBiomes.forEach(biome -> biome.func_226711_a_(Feature.field_214550_p.func_225566_b_((IFeatureConfig)new VillageConfig("village/plains/town_centers", 6))));
    }

    @SubscribeEvent
    public void onVillagerSpawn(EntityJoinWorldEvent event) {
        Biome biome;
        VillagerEntity villager;
        VillagerData data;
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof VillagerEntity && event.getEntity().field_70175_ag && event.getEntity().field_70173_aa == 0 && (data = (villager = (VillagerEntity)event.getEntity()).func_213700_eh()).func_221129_a() == IVillagerType.field_221175_c && plainsBiomes.contains(biome = BiomeHelper.getBiomeAtPos((ServerWorld)event.getWorld(), event.getEntity().func_180425_c()))) {
            villager.func_213753_a(data.func_221134_a(IVillagerType.func_221170_a((Biome)biome)));
        }
    }
}

