/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.client.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import svenhjol.charm.world.tileentity.RunePortalTileEntity;

@OnlyIn(value=Dist.CLIENT)
public class RunePortalTileEntityRenderer<T extends RunePortalTileEntity>
extends TileEntityRenderer<T> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation RUNE_PORTAL_TEXTURE = new ResourceLocation("charm", "textures/entity/rune_portal.png");
    private static final List<RenderType> RENDER_TYPES = (List)IntStream.range(0, 16).mapToObj(i -> RunePortalTileEntityRenderer.getEndPortal(i + 1)).collect(ImmutableList.toImmutableList());

    public RunePortalTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int i = 13;
        float f = 0.75f;
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        this.renderCube(tile, f, 0.15f, 0, matrix4f, bufferIn.getBuffer(RENDER_TYPES.get(0)));
        for (int j = 1; j < i; ++j) {
            this.renderCube(tile, f, 2.0f / (float)(18 - j), j, matrix4f, bufferIn.getBuffer(RENDER_TYPES.get(j)));
        }
    }

    private void renderCube(T tile, float offset, float depth, int pass, Matrix4f matrix4f, IVertexBuilder builder) {
        float f = pass == 0 ? 0.05f : 9.2f / (float)(30 - pass);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (pass >= 0 && ((RunePortalTileEntity)((Object)tile)).colors != null && pass < ((RunePortalTileEntity)((Object)tile)).colors.size()) {
            int colorIndex = ((RunePortalTileEntity)((Object)tile)).colors.get(pass);
            DyeColor dyeColor = DyeColor.func_196056_a((int)colorIndex);
            float[] comps = dyeColor.func_193349_f();
            r = comps[0];
            g = comps[1];
            b = comps[2];
        }
        this.renderFace(tile, matrix4f, builder, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, r *= 1.7f * f, g *= 1.7f * f, b *= 1.7f * f, Direction.SOUTH);
        this.renderFace(tile, matrix4f, builder, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, r, g, b, Direction.NORTH);
        this.renderFace(tile, matrix4f, builder, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, r, g, b, Direction.EAST);
        this.renderFace(tile, matrix4f, builder, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, r, g, b, Direction.WEST);
        this.renderFace(tile, matrix4f, builder, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, Direction.DOWN);
        this.renderFace(tile, matrix4f, builder, 0.0f, 1.0f, offset, offset, 1.0f, 1.0f, 0.0f, 0.0f, r, g, b, Direction.UP);
    }

    private void renderFace(T tileEntityIn, Matrix4f matrix4f, IVertexBuilder builder, float f0, float f1, float f2, float f3, float f4, float f5, float f6, float f7, float red, float green, float blue, Direction direction) {
        if (((RunePortalTileEntity)((Object)tileEntityIn)).shouldRenderFace(direction)) {
            builder.func_227888_a_(matrix4f, f0, f2, f4).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, f1, f2, f5).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, f1, f3, f6).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, f0, f3, f7).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        }
    }

    public static RenderType getEndPortal(int iterationIn) {
        RenderState.TextureState renderstate$texturestate;
        RenderState.TransparencyState renderstate$transparencystate;
        if (iterationIn <= 1) {
            renderstate$transparencystate = RenderType.field_228515_g_;
            renderstate$texturestate = new RenderState.TextureState(END_SKY_TEXTURE, false, false);
        } else {
            renderstate$transparencystate = RenderType.field_228511_c_;
            renderstate$texturestate = new RenderState.TextureState(RUNE_PORTAL_TEXTURE, false, false);
        }
        return RenderType.func_228633_a_((String)"rune_portal", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(renderstate$transparencystate).func_228724_a_(renderstate$texturestate).func_228725_a_((RenderState.TexturingState)new RenderState.PortalTexturingState(iterationIn)).func_228717_a_(RenderType.field_228503_M_).func_228728_a_(false));
    }
}

