/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.block;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.world.module.Fumaroles;
import svenhjol.meson.MesonModule;
import svenhjol.meson.block.MesonBlock;

public class FumaroleBlock
extends MesonBlock {
    public FumaroleBlock(MesonModule module) {
        super(module, "fumarole", Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151655_K).func_200943_b(0.4f).func_200944_c());
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78030_b;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (this.tryAbsorb(worldIn, pos)) {
            this.erupt(worldIn, pos);
        }
    }

    protected boolean tryAbsorb(World world, BlockPos pos) {
        boolean absorbed = false;
        for (Direction direction : Direction.values()) {
            BlockPos next = pos.func_177972_a(direction);
            BlockState state = world.func_180495_p(next);
            IFluidState fluid = world.func_204610_c(next);
            if (!fluid.func_206884_a(FluidTags.field_206960_b)) continue;
            if (state.func_177230_c() instanceof IBucketPickupHandler && ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, next, state) != Fluids.field_204541_a) {
                absorbed = true;
                continue;
            }
            if (state.func_177230_c() != Blocks.field_150353_l) continue;
            absorbed = true;
        }
        return absorbed;
    }

    protected void erupt(World world, BlockPos pos) {
        if (!world.func_175623_d(pos.func_177984_a()) || world.func_175623_d(pos.func_177977_b())) {
            return;
        }
        Random rand = world.field_73012_v;
        if (rand.nextFloat() < 0.5f) {
            return;
        }
        if (!world.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)world;
            float spread = 0.05f;
            double px = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * (double)spread;
            double py = (double)pos.func_177956_o() + 0.5 + ((double)rand.nextFloat() - 0.5) * (double)spread;
            double pz = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * (double)spread;
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_218417_ae, px, py, pz, 60, -0.2, 0.0, 0.0, 0.11);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197594_E, px, py, pz, 60, -0.2, 0.0, 0.0, 0.04);
            serverWorld.func_184133_a(null, pos, CharmSounds.FUMAROLE_ERUPT, SoundCategory.BLOCKS, (float)Fumaroles.eruptionVolume, 0.85f + world.field_73012_v.nextFloat() * 0.25f);
        }
        AxisAlignedBB bb = new AxisAlignedBB(pos);
        Predicate<Entity> selector = entity -> true;
        List entities = world.func_175647_a(Entity.class, bb.func_72314_b(0.0, 10.0, 0.0), selector);
        for (Entity entity2 : entities) {
            Vec3d motion = entity2.func_213322_ci();
            double speed = 1.75 / ((double)(entity2.func_180425_c().func_177956_o() - pos.func_177956_o()) * 0.75);
            entity2.func_213293_j(motion.field_72450_a, speed, motion.field_72449_c);
            entity2.field_70133_I = true;
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        this.erupt((World)world, pos);
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (rand.nextFloat() < 0.1f) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), CharmSounds.FUMAROLE_BUBBLING, SoundCategory.BLOCKS, 0.13f, 0.9f + world.field_73012_v.nextFloat() * 0.2f, false);
        }
        if (!world.func_175623_d(pos.func_177984_a())) {
            return;
        }
        if (rand.nextInt(3) == 0) {
            float spread = 0.5f;
            int amount = rand.nextInt(4) + 1;
            for (int i = 0; i < amount; ++i) {
                float speed = 0.05f + rand.nextFloat() * 0.1f;
                double px = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * (double)spread;
                double py = (double)pos.func_177956_o() + 1.0 + ((double)rand.nextFloat() - 0.5) * (double)spread;
                double pz = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * (double)spread;
                BasicParticleType smoke = rand.nextFloat() < 0.75f ? ParticleTypes.field_218417_ae : ParticleTypes.field_197594_E;
                world.func_195594_a((IParticleData)smoke, px, py, pz, 0.0, (double)speed, 0.0);
            }
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.13f, 0.75f + rand.nextFloat() * 0.25f, false);
        }
    }
}

