/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import svenhjol.meson.MesonModule;
import svenhjol.meson.event.ComposterEvent;
import svenhjol.meson.helper.ComposterHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Tweaks", hasSubscriptions=true)
public class ComposterImprovements
extends MesonModule {
    @Config(name="Input items", description="List of extra items that may be composted.\nSpecify the compost level chance (out of 1.0) after the item name.")
    public static List<String> inputItems = Arrays.asList("minecraft:rotten_flesh=0.3", "minecraft:spider_eye=0.2");
    @Config(name="Output items", description="List of extra items that can be returned from the composter.")
    public static List<String> outputItems = Arrays.asList("minecraft:bone_meal", "minecraft:brown_mushroom", "minecraft:red_mushroom");
    @Config(name="Maximum output", description="Maximum number of extra items returned from composter.")
    public static int maxOutput = 3;

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        for (String input : inputItems) {
            String[] split = input.split("=");
            float chance = Float.parseFloat(split[1]);
            String itemStr = split[0];
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemStr));
            if (item == null || ComposterHelper.getChance(item) != 0.0f) continue;
            ComposterHelper.addInputItem(item, (float)Math.max(1.0, (double)chance));
        }
    }

    @SubscribeEvent
    public void onComposterOutput(ComposterEvent.Output event) {
        if (!event.getWorld().field_72995_K) {
            World world = event.getWorld();
            Random rand = world.field_73012_v;
            int max = Math.max(0, Math.min(maxOutput, 64));
            int num = rand.nextInt(max + 1);
            ArrayList<String> strings = new ArrayList<String>(new LinkedHashSet<String>(outputItems));
            for (int i = 0; i < num; ++i) {
                String itemStr = (String)strings.get(rand.nextInt(strings.size()));
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemStr));
                if (item == null) continue;
                ComposterHelper.spawnOutput(world, event.getPos(), new ItemStack((IItemProvider)item));
            }
        }
    }
}

