/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ImprovedLanternBlock
extends FallingBlock
implements IWaterLoggable {
    public static final BooleanProperty HANGING = BlockStateProperties.field_222514_j;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape NORMAL_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    protected static final VoxelShape HANGING_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    public ImprovedLanternBlock(Block.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate;
            if (direction.func_176740_k() != Direction.Axis.Y || !(blockstate = (BlockState)this.func_176223_P().func_206870_a((IProperty)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return blockstate;
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((IProperty)HANGING) != false ? HANGING_SHAPE : NORMAL_SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = ImprovedLanternBlock.getHangingDirection(state).func_176734_d();
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d());
    }

    protected static Direction getHangingDirection(BlockState p_220277_0_) {
        return (Boolean)p_220277_0_.func_177229_b((IProperty)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{HANGING, WATERLOGGED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return stateIn;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue() && worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)));
            super.func_225534_a_(state, worldIn, pos, rand);
        } else if (!((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
            super.func_225534_a_(state, worldIn, pos, rand);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }
}

