/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.smithing.module;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.meson.MesonModule;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Smithing", hasSubscriptions=true, description="Extract enchantments from any enchanted item into an empty book.\nThe enchantments are weakened in the process and the original item is destroyed.")
public class ExtractEnchantments
extends MesonModule {
    @Config(name="Base XP cost", description="Minimum cost before adding XP equivalent to the enchantment level(s) of the item.")
    public static int baseCost = 1;
    @Config(name="Enchantment levels lost", description="Number of levels that enchantments are weakened when converting.")
    public static int levelsLost = 1;
    @Config(name="Allow Level 1 enchantments", description="Enchantments with a single level or at level 1 will be extracted.")
    public static boolean allowLevelOneEnchants = true;

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_190926_b() || right.func_190926_b()) {
            return;
        }
        if (right.func_77973_b() != Items.field_151122_aG) {
            return;
        }
        ListNBT leftTags = left.func_77986_q();
        ListNBT rightTags = right.func_77986_q();
        if (leftTags.isEmpty() || !rightTags.isEmpty()) {
            return;
        }
        int cost = baseCost;
        Map inEnchants = EnchantmentHelper.func_82781_a((ItemStack)left);
        HashMap<Enchantment, Integer> outEnchants = new HashMap<Enchantment, Integer>();
        for (Map.Entry entry : inEnchants.entrySet()) {
            Enchantment ench = (Enchantment)entry.getKey();
            if (ench == null) {
                return;
            }
            int level2 = (Integer)entry.getValue();
            int newLevel = level2 - levelsLost;
            if (allowLevelOneEnchants) {
                newLevel = Math.max(1, newLevel);
            }
            if (newLevel <= 0 || !ench.isAllowedOnBooks()) continue;
            outEnchants.put(ench, newLevel);
            cost += newLevel;
        }
        if (outEnchants.values().size() == 0) {
            event.setCanceled(true);
            return;
        }
        if (left.func_77978_p() != null && !left.func_77978_p().isEmpty()) {
            cost += left.func_77978_p().func_74762_e("RepairCost");
        }
        ItemStack out = new ItemStack((IItemProvider)Items.field_151134_bR);
        outEnchants.forEach((e, level) -> EnchantedBookItem.func_92115_a((ItemStack)out, (EnchantmentData)new EnchantmentData(e, level.intValue())));
        String name = event.getName();
        if (name != null && !name.isEmpty()) {
            out.func_200302_a((ITextComponent)new StringTextComponent(name));
        }
        event.setCost(cost);
        event.setMaterialCost(1);
        event.setOutput(out);
    }
}

