/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.module;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.enchanting.enchantment.MagneticEnchantment;
import svenhjol.meson.MesonEnchantment;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.EnchantmentsHelper;
import svenhjol.meson.helper.WorldHelper;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Enchanting", hasSubscriptions=true, description="Tools with the Magnetic enchantment automatically pick up drops.")
public class Magnetic
extends MesonModule {
    public static int range = 6;
    public static Map<BlockPos, PlayerEntity> dropmap = new HashMap<BlockPos, PlayerEntity>();
    public static MesonEnchantment enchantment;

    @Override
    public void init() {
        enchantment = new MagneticEnchantment(this);
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent event) {
        if (EnchantmentsHelper.hasEnchantment(enchantment, event.getPlayer().func_184614_ca())) {
            dropmap.put(event.getPos(), event.getPlayer());
        } else {
            dropmap.values().remove(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onEntityCreate(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ItemEntity && !event.getWorld().field_72995_K) {
            int r = range;
            BlockPos foundPos = null;
            for (BlockPos pos : dropmap.keySet()) {
                double dist = WorldHelper.getDistanceSq(pos, event.getEntity().func_180425_c());
                if (!(dist <= (double)r)) continue;
                foundPos = pos;
                break;
            }
            if (foundPos != null) {
                PlayerEntity player = dropmap.get(foundPos);
                BlockPos playerPos = player.func_180425_c();
                ItemEntity fake = new ItemEntity(player.field_70170_p, (double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p());
                ItemStack item = ((ItemEntity)event.getEntity()).func_92059_d();
                fake.func_92058_a(item);
                dropmap.remove(foundPos);
                if (!MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(player, fake)) && player.field_71071_by.func_70441_a(item)) {
                    player.field_70170_p.func_184133_a(null, foundPos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    event.setCanceled(true);
                }
            }
        }
    }
}

