/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.module;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.enchanting.enchantment.LeechingCurseEnchantment;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.EnchantmentsHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Enchanting", hasSubscriptions=true, description="An item with the Leeching curse restores your hunger at the expense of durability.")
public class Leeching
extends MesonModule {
    public static LeechingCurseEnchantment enchantment;
    @Config(name="Hunger restored", description="Amount of hunger restored to the player when the item is damaged.")
    public static int restored;
    @Config(name="Chance", description="Chance (out of 1.0) of item taking durability damage when player is hungry.")
    public static double chance;
    @Config(name="Durability damage", description="Amount of durability damage given to the item when restoring hunger.")
    public static int damage;

    @Override
    public void init() {
        enchantment = new LeechingCurseEnchantment(this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player != null && event.player.func_70089_S() && !event.player.field_70170_p.field_72995_K && event.player.field_70170_p.func_82737_E() % 20L == 0L) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            if ((double)player.field_70170_p.field_73012_v.nextFloat() < chance) {
                int size = player.field_71071_by.func_70302_i_();
                for (int i = 0; i < size; ++i) {
                    ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
                    if (stackInSlot.func_190926_b() || !EnchantmentsHelper.hasEnchantment(enchantment, stackInSlot)) continue;
                    this.damageItemAndRestoreHunger(player, stackInSlot);
                }
            }
        }
    }

    private void damageItemAndRestoreHunger(ServerPlayerEntity player, ItemStack heldItem) {
        FoodStats foodStats = player.func_71024_bL();
        if (foodStats.func_75121_c()) {
            int level = foodStats.func_75116_a();
            foodStats.func_75114_a(level + restored);
            heldItem.func_222118_a(damage, (LivingEntity)player, p -> {});
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.34f, 1.0f);
        }
    }

    static {
        restored = 1;
        chance = 0.05;
        damage = 3;
    }
}

