/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.brewing.module;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import svenhjol.charm.brewing.block.FlavoredCakeBlock;
import svenhjol.charm.brewing.message.ClientCakeAction;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.ComposterHelper;
import svenhjol.meson.helper.ForgeHelper;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Brewing", hasSubscriptions=true, description="Right-click a Long Potion on a cake to make a Flavored Cake that gives the potion effect after eating each slice.You can also make a Flavored Cake using a dispenser.")
public class FlavoredCake
extends MesonModule {
    @Config(name="Effect duration multiplier", description="Effect duration of a single slice of cake as a multiplier of the original potion duration.")
    public static double multiplier = 0.1;
    public static List<String> validPotions = Arrays.asList("fire_resistance", "invisibility", "leaping", "night_vision", "regeneration", "strength", "swiftness", "water_breathing", "quark:danger_sight", "quark:resilience", "quark:resistance");
    public static Map<String, FlavoredCakeBlock> cakes = new HashMap<String, FlavoredCakeBlock>();

    @Override
    public void init() {
        validPotions.forEach(potionName -> {
            String baseName;
            String modName;
            if (potionName.contains(":")) {
                String[] split = potionName.split(":");
                modName = split[0];
                baseName = split[1];
                if (!ForgeHelper.isModLoaded(modName)) {
                    return;
                }
            } else {
                modName = "minecraft";
                baseName = potionName;
            }
            FlavoredCakeBlock cake = new FlavoredCakeBlock(this, modName, baseName);
            cakes.put(modName + ":" + baseName, cake);
        });
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151068_bn, (IDispenseItemBehavior)new DispenseImbueBehavior());
        cakes.forEach((s, flavoredCakeBlock) -> ComposterHelper.addInputItem(new ItemStack((IItemProvider)flavoredCakeBlock).func_77973_b(), 1.0f));
    }

    @SubscribeEvent
    public void onPotionUse(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getPlayer().func_184586_b(event.getHand());
        boolean result = FlavoredCake.imbue(event.getWorld(), event.getPos(), held);
        if (result) {
            if (!event.getWorld().field_72995_K) {
                PlayerHelper.addOrDropStack(event.getPlayer(), new ItemStack((IItemProvider)Items.field_151069_bo));
            }
            event.setCanceled(true);
        }
    }

    public static boolean imbue(World world, BlockPos pos, ItemStack stack) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150414_aQ || block instanceof FlavoredCakeBlock && cakes.containsValue(block)) {
            if ((Integer)state.func_177229_b((IProperty)CakeBlock.field_176589_a) > 0) {
                return false;
            }
            Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
            ResourceLocation potionRes = potion.getRegistryName();
            if (potionRes == null) {
                return false;
            }
            String potionName = potionRes.toString().replace("long_", "");
            if (cakes.containsKey(potionName)) {
                if (state == cakes.get(potionName).func_176223_P()) {
                    return false;
                }
                BlockState imbued = (BlockState)cakes.get(potionName).func_176223_P().func_206870_a((IProperty)FlavoredCakeBlock.field_176589_a, state.func_177229_b((IProperty)FlavoredCakeBlock.field_176589_a));
                world.func_180501_a(pos, imbued, 2);
                stack.func_190918_g(1);
                if (!world.field_72995_K) {
                    world.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 0.5f, 1.1f);
                    Meson.getInstance("charm").getPacketHandler().sendToAll(new ClientCakeAction(pos));
                }
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void effectImbue(BlockPos pos) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        for (int i = 0; i < 8; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            double dx = (float)pos.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
            double dy = (float)pos.func_177956_o() + 0.65f;
            double dz = (float)pos.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
            world.func_195594_a((IParticleData)ParticleTypes.field_197607_R, dx, dy, dz, d0, d1, d2);
        }
    }

    public static class DispenseImbueBehavior
    extends DefaultDispenseItemBehavior {
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            BlockPos pos;
            World world = source.func_197524_h();
            boolean result = FlavoredCake.imbue(world, pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)), stack);
            if (!result) {
                return super.func_82487_b(source, stack);
            }
            return stack;
        }
    }
}

