/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import knightminer.ceramics.client.ItemLayerModelPatch;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@ParametersAreNonnullByDefault
public final class ClayBucketModel
implements IModelGeometry<ClayBucketModel> {
    private static final float NORTH_Z_INNER = 0.53f;
    private static final float SOUTH_Z_INNER = 0.47f;
    private static final float NORTH_Z_FLUID = 0.469375f;
    private static final float SOUTH_Z_FLUID = 0.530625f;
    @Nonnull
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean tint;

    public ClayBucketModel(Fluid fluid, boolean flipGas, boolean tint) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.tint = tint;
    }

    public ClayBucketModel withFluid(Fluid newFluid) {
        return new ClayBucketModel(newFluid, this.flipGas, this.tint);
    }

    private static Material getMaterial(IModelConfiguration owner, String name) {
        Material location = owner.resolveTexture(name);
        if (MissingTextureSprite.func_195675_b().equals((Object)location.func_229313_b_())) {
            return null;
        }
        return location;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particleSprite;
        Material particleLocation = ClayBucketModel.getMaterial(owner, "particle");
        Material baseLocation = ClayBucketModel.getMaterial(owner, "base");
        Material fluidMaskLocation = ClayBucketModel.getMaterial(owner, "fluid");
        Material innerLocation = ClayBucketModel.getMaterial(owner, "inner");
        IModelTransform transformsFromModel = owner.getCombinedTransform();
        ImmutableMap transformMap = transformsFromModel != null ? PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(transformsFromModel, modelTransform)) : PerspectiveMapWrapper.getTransforms((IModelTransform)modelTransform);
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (this.flipGas && this.fluid != Fluids.field_204541_a && this.fluid.getAttributes().isLighterThanAir()) {
            modelTransform = new ModelTransformComposition(modelTransform, (IModelTransform)new SimpleModelTransform(new TransformationMatrix(null, new Quaternion(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TransformationMatrix transform = modelTransform.func_225615_b_();
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid == Fluids.field_204541_a) {
            if (innerLocation == null) {
                innerLocation = baseLocation;
            }
            if (particleSprite == null) {
                particleSprite = spriteGetter.apply(innerLocation);
            }
            builder.addAll(ItemLayerModelPatch.getQuadsForSprites((List<Material>)ImmutableList.of((Object)innerLocation), transform, spriteGetter));
        } else {
            TextureAtlasSprite templateSprite;
            if (baseLocation != null) {
                builder.addAll(ItemLayerModelPatch.getQuadsForSprites((List<Material>)ImmutableList.of((Object)baseLocation), transform, spriteGetter));
            }
            TextureAtlasSprite fluidSprite = spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)this.fluid.getAttributes().getStillTexture()));
            if (particleSprite == null) {
                particleSprite = fluidSprite;
            }
            if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
                int color = this.tint ? this.fluid.getAttributes().getColor() : -1;
                builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.469375f, (Direction)Direction.NORTH, (int)color, (int)1));
                builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.530625f, (Direction)Direction.SOUTH, (int)color, (int)1));
            }
            if (innerLocation != null) {
                TextureAtlasSprite innerSprite = spriteGetter.apply(innerLocation);
                builder.add((Object)ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.53f, (TextureAtlasSprite)innerSprite, (Direction)Direction.NORTH, (int)-1, (int)2));
                builder.add((Object)ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.47f, (TextureAtlasSprite)innerSprite, (Direction)Direction.SOUTH, (int)-1, (int)2));
            }
        }
        return new BakedModel(bakery, owner, this, builder.build(), particleSprite, Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap(), transform.isIdentity(), modelTransform, owner.isSideLit());
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        texs.add(owner.resolveTexture("particle"));
        texs.add(owner.resolveTexture("base"));
        texs.add(owner.resolveTexture("inner"));
        texs.add(owner.resolveTexture("fluid"));
        return texs;
    }

    private static final class BakedModel
    extends BakedItemModel {
        private final IModelConfiguration owner;
        private final ClayBucketModel parent;
        private final Map<String, IBakedModel> cache;
        private final IModelTransform originalTransform;

        private BakedModel(ModelBakery bakery, IModelConfiguration owner, ClayBucketModel parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms, Map<String, IBakedModel> cache, boolean untransformed, IModelTransform originalTransform, boolean isSideLit) {
            super(quads, particle, transforms, (ItemOverrideList)new ContainedFluidOverrideHandler(bakery), untransformed, isSideLit);
            this.owner = owner;
            this.parent = parent;
            this.cache = cache;
            this.originalTransform = originalTransform;
        }
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrideList {
        private static final ResourceLocation REBAKE_LOCATION = new ResourceLocation("ceramics:bucket_override");
        private final ModelBakery bakery;

        private ContainedFluidOverrideHandler(ModelBakery bakery) {
            this.bakery = bakery;
        }

        public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            return (IBakedModel)FluidUtil.getFluidContained((ItemStack)stack).map(fluidStack -> {
                BakedModel model = (BakedModel)originalModel;
                Fluid fluid = fluidStack.getFluid();
                String name = fluid.getRegistryName().toString();
                if (!model.cache.containsKey(name)) {
                    ClayBucketModel parent = model.parent.withFluid(fluid);
                    IBakedModel bakedModel = parent.bake(model.owner, this.bakery, ModelLoader.defaultTextureGetter(), model.originalTransform, model.func_188617_f(), REBAKE_LOCATION);
                    model.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return (IBakedModel)model.cache.get(name);
            }).orElse((Object)originalModel);
        }
    }

    public static enum Loader implements IModelLoader<ClayBucketModel>
    {
        INSTANCE;


        public IResourceType getResourceType() {
            return VanillaResourceType.MODELS;
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }

        public ClayBucketModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            Fluid fluid = null;
            if (modelContents.has("fluid")) {
                ResourceLocation fluidName = new ResourceLocation(modelContents.get("fluid").getAsString());
                fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
            }
            if (fluid == null) {
                fluid = Fluids.field_204541_a;
            }
            boolean flip = false;
            if (modelContents.has("flipGas")) {
                flip = modelContents.get("flipGas").getAsBoolean();
            }
            boolean tint = true;
            if (modelContents.has("applyTint")) {
                tint = modelContents.get("applyTint").getAsBoolean();
            }
            return new ClayBucketModel(fluid, flip, tint);
        }
    }
}

