/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.plugin.jei;

import java.util.List;
import knightminer.ceramics.Registration;
import knightminer.ceramics.recipe.KilnRecipe;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ForgeI18n;

@MethodsReturnNonnullByDefault
public class KilnCategory
implements IRecipeCategory<KilnRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("ceramics", "kiln");
    private static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    public static final int INPUT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public KilnCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(RECIPE_GUI_VANILLA, 0, 114, 82, 54);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(Registration.KILN));
        this.localizedName = ForgeI18n.parseMessage((String)"gui.jei.category.ceramics.kiln", (Object[])new Object[0]);
        IDrawableStatic staticFlame = guiHelper.createDrawable(RECIPE_GUI_VANILLA, 82, 114, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = guiHelper.drawableBuilder(RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends KilnRecipe> getRecipeClass() {
        return KilnRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setIngredients(KilnRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, KilnRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }

    public void draw(KilnRecipe recipe, double mouseX, double mouseY) {
        this.animatedFlame.draw(1, 20);
        this.arrow.draw(24, 18);
        float experience = recipe.func_222138_b();
        if (experience > 0.0f) {
            String experienceString = I18n.func_135052_a((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_211126_b(experienceString, (float)(this.background.getWidth() - stringWidth), 0.0f, -8355712);
        }
    }
}

