/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.items;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import knightminer.ceramics.items.BaseClayBucketItem;
import knightminer.ceramics.recipe.CeramicsTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
public class ClayBucketItem
extends BaseClayBucketItem {
    private static final Set<Fluid> FLUID_BLACKLIST = ImmutableSet.of((Object)Fluids.field_204541_a, (Object)Fluids.field_207212_b, (Object)Fluids.field_207213_d);

    public ClayBucketItem(boolean isCracked, Item.Properties props) {
        super(isCracked, props);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack;
        Fluid fluid = this.getFluid(stack = player.func_184586_b(hand));
        RayTraceResult trace = ClayBucketItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)(fluid == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)player, (World)world, (ItemStack)stack, (RayTraceResult)trace);
        if (ret != null) {
            return ret;
        }
        if (trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
        BlockPos pos = blockTrace.func_216350_a();
        Direction direction = blockTrace.func_216354_b();
        BlockPos offset = pos.func_177972_a(direction);
        if (world.func_175660_a(player, pos) && player.func_175151_a(offset, direction, stack)) {
            ActionResult<ItemStack> result;
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block == Blocks.field_150383_bp && !player.func_213453_ef() && (result = this.interactWithCauldron(world, pos, state, player, stack, fluid)).func_188397_a() != ActionResultType.PASS) {
                return result;
            }
            if (fluid == Fluids.field_204541_a) {
                Fluid newFluid;
                if (block instanceof IBucketPickupHandler && (newFluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)world, pos, state)) != Fluids.field_204541_a) {
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    SoundEvent sound = newFluid.getAttributes().getFillSound();
                    if (sound == null) {
                        sound = newFluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    }
                    player.func_184185_a(sound, 1.0f, 1.0f);
                    ItemStack newStack = ClayBucketItem.updateBucket(stack, player, this.withFluid(newFluid));
                    if (!world.func_201670_d()) {
                        CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, newStack.func_77946_l());
                    }
                    return ActionResult.func_226248_a_((Object)newStack);
                }
            } else {
                BlockPos fluidPos;
                BlockPos blockPos = fluidPos = state.func_177230_c() instanceof ILiquidContainer && fluid == Fluids.field_204546_a ? pos : offset;
                if (this.tryPlaceContainedLiquid(player, world, fluidPos, stack, blockTrace)) {
                    ClayBucketItem.onLiquidPlaced(fluid, world, stack, fluidPos);
                    if (player instanceof ServerPlayerEntity) {
                        CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, fluidPos, stack);
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    return ActionResult.func_226248_a_((Object)ClayBucketItem.emptyBucket(stack, player));
                }
            }
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    private static void onLiquidPlaced(Fluid fluid, World world, ItemStack stack, BlockPos pos) {
        Item item = fluid.func_204524_b();
        if (item instanceof BucketItem) {
            ((BucketItem)item).func_203792_a(world, stack, pos);
        }
    }

    private boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World world, BlockPos pos, ItemStack stack, @Nullable BlockRayTraceResult trace) {
        Fluid fluidStack = this.getFluid(stack);
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean replaceable = state.func_227032_a_(fluid);
        if (state.isAir((IBlockReader)world, pos) || replaceable || block instanceof ILiquidContainer && ((ILiquidContainer)block).func_204510_a((IBlockReader)world, pos, state, fluid)) {
            if (world.field_73011_w.func_177500_n() && fluid.func_207185_a(FluidTags.field_206959_a)) {
                world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (block instanceof ILiquidContainer && fluid == Fluids.field_204546_a) {
                if (((ILiquidContainer)block).func_204509_a((IWorld)world, pos, state, ((FlowingFluid)fluid).func_207204_a(false))) {
                    this.playEmptySound(fluid, player, (IWorld)world, pos);
                }
            } else {
                if (!world.func_201670_d() && replaceable && !state.func_185904_a().func_76224_d()) {
                    world.func_175655_b(pos, true);
                }
                this.playEmptySound(fluid, player, (IWorld)world, pos);
                world.func_180501_a(pos, fluid.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        if (trace == null) {
            return false;
        }
        return this.tryPlaceContainedLiquid(player, world, trace.func_216350_a().func_177972_a(trace.func_216354_b()), stack, null);
    }

    private void playEmptySound(Fluid fluid, @Nullable PlayerEntity player, IWorld world, BlockPos pos) {
        SoundEvent sound = fluid.getAttributes().getEmptySound();
        if (sound == null) {
            sound = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private ActionResult<ItemStack> interactWithCauldron(World world, BlockPos pos, BlockState state, @Nullable PlayerEntity player, ItemStack stack, Fluid fluid) {
        int level = (Integer)state.func_177229_b((IProperty)CauldronBlock.field_176591_a);
        if (fluid == Fluids.field_204541_a) {
            if (level == 3) {
                if (player != null) {
                    player.func_195066_a(Stats.field_188078_L);
                }
                if (!world.func_201670_d()) {
                    ((CauldronBlock)Blocks.field_150383_bp).func_176590_a(world, pos, state, 0);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResult.func_226248_a_((Object)this.withFluid((Fluid)Fluids.field_204546_a));
            }
        } else if (fluid == Fluids.field_204546_a) {
            if (level < 3) {
                if (player != null) {
                    player.func_195066_a(Stats.field_188077_K);
                }
                if (!world.field_72995_K) {
                    ((CauldronBlock)Blocks.field_150383_bp).func_176590_a(world, pos, state, 3);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResult.func_226248_a_((Object)stack.getContainerItem());
            }
        } else {
            return ActionResult.func_226250_c_((Object)stack);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (!player.func_184812_l_() && !this.hasFluid(stack) && target instanceof CowEntity && !target.func_70631_g_()) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            if (!player.func_130014_f_().func_201670_d()) {
                ClayBucketItem.addItem(player, this.withMilk());
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.hasFluid(stack) ? 1 : 16;
    }

    public int getBurnTime(ItemStack stack) {
        return this.getFluid(stack) == Fluids.field_204547_b ? 20000 : 0;
    }

    @Nonnull
    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent component;
        Fluid fluid = this.getFluid(stack);
        if (fluid == Fluids.field_204541_a) {
            component = super.func_200295_i(stack);
        } else {
            String key = this.func_77667_c(stack);
            ResourceLocation location = fluid.getRegistryName();
            String fluidKey = String.format("%s.%s.%s", key, location.func_110624_b(), location.func_110623_a());
            component = ForgeI18n.getPattern((String)fluidKey).equals(fluidKey) ? new TranslationTextComponent(key + ".filled", new Object[]{new FluidStack(fluid, 1000).getDisplayName()}) : new TranslationTextComponent(fluidKey, new Object[0]);
        }
        return component.func_211708_a(TextFormatting.RED);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            if (!this.isCracked) {
                subItems.add((Object)new ItemStack((IItemProvider)this));
            }
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                if (FLUID_BLACKLIST.contains(fluid) || fluid.func_207185_a(CeramicsTags.Fluids.MILK) || this.isCracked != this.doesCrack(fluid)) continue;
                subItems.add((Object)ClayBucketItem.setFluid(new ItemStack((IItemProvider)this), fluid));
            }
        }
    }
}

