/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import knightminer.ceramics.Registration;
import knightminer.ceramics.recipe.CeramicsTags;
import knightminer.ceramics.util.FluidClayBucketWrapper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BaseClayBucketItem
extends Item {
    private static final String TAG_FLUID = "fluid";
    private static final float DEGREE_TO_RAD = (float)Math.PI / 180;
    protected boolean isCracked;

    public BaseClayBucketItem(boolean isCracked, Item.Properties props) {
        super(props);
        this.isCracked = isCracked;
        if (isCracked) {
            MinecraftForge.EVENT_BUS.addListener(this::onItemDestroyed);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidClayBucketWrapper(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isCracked) {
            tooltip.add(new TranslationTextComponent(this.func_77658_a() + ".tooltip", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    private void onItemDestroyed(PlayerDestroyItemEvent event) {
        ItemStack original = event.getOriginal();
        if (original.func_77973_b() == this) {
            BaseClayBucketItem.renderBrokenItem(event.getPlayer(), event.getOriginal());
        }
    }

    protected static void renderBrokenItem(PlayerEntity player, ItemStack stack) {
        World world = player.func_130014_f_();
        world.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187635_cQ, player.func_184176_by(), 0.8f, 0.8f + world.field_73012_v.nextFloat() * 0.4f, false);
        Random rand = player.func_70681_au();
        ItemParticleData particle = new ItemParticleData(ParticleTypes.field_197591_B, stack);
        for (int i = 0; i < 5; ++i) {
            Vec3d offset = new Vec3d(((double)rand.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            offset = offset.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
            offset = offset.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
            Vec3d pos = new Vec3d(((double)rand.nextFloat() - 0.5) * 0.3, (double)(-rand.nextFloat()) * 0.6 - 0.3, 0.6);
            pos = pos.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
            pos = pos.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
            pos = pos.func_72441_c(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
            if (world instanceof ServerWorld) {
                ((ServerWorld)world).func_195598_a((IParticleData)particle, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1, offset.field_72450_a, offset.field_72448_b + 0.05, offset.field_72449_c, 0.0);
                continue;
            }
            world.func_195594_a((IParticleData)particle, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, offset.field_72450_a, offset.field_72448_b + 0.05, offset.field_72449_c);
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.isCracked && !this.hasFluid(stack) && super.hasContainerItem(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (this.isCracked) {
            return ItemStack.field_190927_a;
        }
        if (!this.hasFluid(stack)) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(Registration.CLAY_BUCKET);
    }

    protected static ItemStack emptyBucket(ItemStack stack, PlayerEntity player) {
        return !player.func_184812_l_() ? stack.getContainerItem() : stack;
    }

    protected static ItemStack updateBucket(ItemStack originalStack, PlayerEntity player, ItemStack newBucket) {
        if (player.func_184812_l_()) {
            return originalStack;
        }
        originalStack.func_190918_g(1);
        if (originalStack.func_190926_b()) {
            return newBucket;
        }
        BaseClayBucketItem.addItem(player, newBucket);
        return originalStack;
    }

    protected static void addItem(PlayerEntity player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    protected boolean hasFluid(ItemStack container) {
        return this.getFluid(container) != Fluids.field_204541_a;
    }

    public Fluid getFluid(ItemStack stack) {
        CompoundNBT tags = stack.func_77978_p();
        if (tags != null) {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tags.func_74779_i(TAG_FLUID)));
            return fluid == null ? Fluids.field_204541_a : fluid;
        }
        return Fluids.field_204541_a;
    }

    public ItemStack withFluid(Fluid fluid) {
        if (fluid.func_207185_a(CeramicsTags.Fluids.MILK)) {
            return this.withMilk();
        }
        return BaseClayBucketItem.setFluid(new ItemStack(this.isCracked || this.doesCrack(fluid) ? Registration.CRACKED_CLAY_BUCKET : Registration.CLAY_BUCKET), fluid);
    }

    protected ItemStack withMilk() {
        return new ItemStack(this.isCracked ? Registration.CRACKED_MILK_CLAY_BUCKET : Registration.MILK_CLAY_BUCKET);
    }

    protected boolean doesCrack(Fluid fluid) {
        return fluid.getAttributes().getTemperature() >= 450;
    }

    protected static ItemStack setFluid(ItemStack stack, Fluid fluid) {
        stack.func_196082_o().func_74778_a(TAG_FLUID, fluid.getRegistryName().toString());
        return stack;
    }

    public static String getSubtype(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i(TAG_FLUID);
        }
        return "";
    }
}

