/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.datagen;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import knightminer.ceramics.Registration;
import knightminer.ceramics.blocks.RainbowPorcelain;
import knightminer.ceramics.recipe.CeramicsTags;
import knightminer.ceramics.registration.BuildingBlockObject;
import knightminer.ceramics.registration.EnumBlockObject;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class RecipeProvider
extends net.minecraft.data.RecipeProvider {
    private static final BuildingBlockObject BRICKS = BuildingBlockObject.fromBlocks(Blocks.field_196584_bK, Blocks.field_196571_bA, Blocks.field_150389_bf, Blocks.field_222459_lw);
    private static final Map<DyeColor, Block> GLAZED_TERRACOTTA;

    public RecipeProvider(DataGenerator gen) {
        super(gen);
    }

    @Nonnull
    public String func_200397_b() {
        return "Ceramics Recipes";
    }

    protected void func_200404_a(@Nonnull Consumer<IFinishedRecipe> consumer) {
        InventoryChangeTrigger.Instance terracottaCriteria = this.func_200409_a(CeramicsTags.Items.COLORED_TERRACOTTA);
        this.eachEnum(Registration.TERRACOTTA, (Enum[])DyeColor.values(), (arg_0, arg_1) -> RecipeProvider.lambda$registerRecipes$0((ICriterionInstance)terracottaCriteria, consumer, arg_0, arg_1));
        ShapelessRecipeBuilder.func_200488_a(Registration.UNFIRED_PORCELAIN, (int)4).func_203221_a(Tags.Items.GEMS_QUARTZ).func_200487_b((IItemProvider)Items.field_151119_aD).func_200487_b((IItemProvider)Items.field_151119_aD).func_200487_b((IItemProvider)Items.field_151119_aD).func_200483_a("has_quartz", (ICriterionInstance)this.func_200409_a(Tags.Items.GEMS_QUARTZ)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a(Registration.UNFIRED_PORCELAIN_BLOCK).func_200462_a(Character.valueOf('b'), Registration.UNFIRED_PORCELAIN).func_200472_a("bb").func_200472_a("bb").func_200465_a("has_item", (ICriterionInstance)this.func_200403_a(Registration.UNFIRED_PORCELAIN)).func_200464_a(consumer);
        this.kilnFurnaceRecipe(consumer, Registration.UNFIRED_PORCELAIN_BLOCK, (IItemProvider)Registration.PORCELAIN_BLOCK.asItem(DyeColor.WHITE), 0.3f);
        InventoryChangeTrigger.Instance porcelainCriteria = this.func_200403_a((IItemProvider)Registration.PORCELAIN_BLOCK.asItem(DyeColor.WHITE));
        this.eachEnum(Registration.PORCELAIN_BLOCK, (Enum[])DyeColor.values(), (arg_0, arg_1) -> RecipeProvider.lambda$registerRecipes$1((ICriterionInstance)porcelainCriteria, consumer, arg_0, arg_1));
        this.kilnFurnaceRecipe(consumer, CeramicsTags.Items.COLORED_PORCELAIN, (IItemProvider)Registration.RAINBOW_PORCELAIN.asItem(RainbowPorcelain.RED), 0.1f, RecipeProvider.location("rainbow_porcelain"));
        InventoryChangeTrigger.Instance hasTheRainbow = this.func_200409_a(CeramicsTags.Items.RAINBOW_PORCELAIN);
        this.eachEnum(Registration.RAINBOW_PORCELAIN, RainbowPorcelain.values(), (arg_0, arg_1) -> RecipeProvider.lambda$registerRecipes$2((ICriterionInstance)hasTheRainbow, consumer, arg_0, arg_1));
        InventoryChangeTrigger.Instance hasClayBrick = this.func_200403_a((IItemProvider)Items.field_151118_aC);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_221724_bx).func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151118_aC).func_200472_a("bb").func_200465_a("has_bricks", (ICriterionInstance)hasClayBrick).func_200473_b(Items.field_221724_bx.getRegistryName().func_110623_a()).func_200467_a(consumer, RecipeProvider.location("brick_slab_from_bricks"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_221810_do).func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151118_aC).func_200472_a("b  ").func_200472_a("bb ").func_200472_a("bbb").func_200465_a("has_bricks", (ICriterionInstance)hasClayBrick).func_200473_b(Items.field_221810_do.getRegistryName().func_110623_a()).func_200467_a(consumer, RecipeProvider.location("brick_stairs_from_bricks"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_221647_bL).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_221724_bx).func_200472_a("B").func_200472_a("B").func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221724_bx)).func_200473_b(Items.field_221647_bL.getRegistryName().func_110623_a()).func_200467_a(consumer, RecipeProvider.location("bricks_from_slab"));
        this.eachBuilding(BRICKS, Registration.DARK_BRICKS, (input, output) -> this.kilnFurnaceRecipe(consumer, (IItemProvider)input, (IItemProvider)output, 0.1f));
        this.registerSlabStairWall(consumer, Registration.DARK_BRICKS);
        InventoryChangeTrigger.Instance hasLava = this.func_200403_a((IItemProvider)Items.field_151129_at);
        this.addBrickRecipe(consumer, BRICKS, Items.field_151129_at, Registration.LAVA_BRICKS, "lava");
        this.registerSlabStairWall(consumer, Registration.LAVA_BRICKS);
        this.addBrickRecipe(consumer, BRICKS, Items.field_185157_bK, Registration.DRAGON_BRICKS, "dragon");
        this.registerSlabStairWall(consumer, Registration.DRAGON_BRICKS);
        this.kilnFurnaceRecipe(consumer, Registration.UNFIRED_PORCELAIN, Registration.PORCELAIN_BRICK, 0.3f);
        InventoryChangeTrigger.Instance hasBricks = this.func_200403_a(Registration.PORCELAIN_BRICK);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Registration.PORCELAIN_BRICKS).func_200462_a(Character.valueOf('b'), Registration.PORCELAIN_BRICK).func_200472_a("bb").func_200472_a("bb").func_200465_a("has_bricks", (ICriterionInstance)hasBricks).func_200473_b(Registration.PORCELAIN_BRICK.getRegistryName().toString()).func_200464_a(consumer);
        BlockItem porcelainSlab = Registration.PORCELAIN_BRICKS.getSlabItem();
        ShapedRecipeBuilder.func_200470_a((IItemProvider)porcelainSlab).func_200462_a(Character.valueOf('b'), Registration.PORCELAIN_BRICK).func_200472_a("bb").func_200465_a("has_bricks", (ICriterionInstance)hasBricks).func_200473_b(porcelainSlab.getRegistryName().toString()).func_200467_a(consumer, RecipeProvider.suffix((IItemProvider)porcelainSlab, "_from_bricks"));
        BlockItem porcelainStairs = Registration.PORCELAIN_BRICKS.getStairsItem();
        ShapedRecipeBuilder.func_200470_a((IItemProvider)porcelainStairs).func_200462_a(Character.valueOf('b'), Registration.PORCELAIN_BRICK).func_200472_a("b  ").func_200472_a("bb ").func_200472_a("bbb").func_200465_a("has_bricks", (ICriterionInstance)hasBricks).func_200473_b(porcelainStairs.getRegistryName().toString()).func_200467_a(consumer, RecipeProvider.suffix((IItemProvider)porcelainStairs, "_from_bricks"));
        this.registerSlabStairWall(consumer, Registration.PORCELAIN_BRICKS);
        this.addBrickRecipe(consumer, Registration.PORCELAIN_BRICKS, Items.field_151074_bl, Registration.GOLDEN_BRICKS, "gold");
        this.registerSlabStairWall(consumer, Registration.GOLDEN_BRICKS);
        this.addBrickRecipe(consumer, Registration.PORCELAIN_BRICKS, Items.field_179562_cC, Registration.MARINE_BRICKS, "prismarine");
        this.registerSlabStairWall(consumer, Registration.MARINE_BRICKS);
        this.addBrickRecipe(consumer, Registration.PORCELAIN_BRICKS, Items.field_196136_br, Registration.MONOCHROME_BRICKS, "ink");
        this.registerSlabStairWall(consumer, Registration.MONOCHROME_BRICKS);
        this.eachBuilding(Registration.PORCELAIN_BRICKS, Registration.RAINBOW_BRICKS, (input, output) -> this.kilnFurnaceRecipe(consumer, (IItemProvider)input, (IItemProvider)output, 0.1f));
        this.registerSlabStairWall(consumer, Registration.RAINBOW_BRICKS);
        ShapedRecipeBuilder.func_200470_a(Registration.UNFIRED_CLAY_BUCKET).func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_151119_aD).func_200472_a("c c").func_200472_a(" c ").func_200465_a("has_clay", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151119_aD)).func_200464_a(consumer);
        this.kilnFurnaceRecipe(consumer, Registration.UNFIRED_CLAY_BUCKET, Registration.CLAY_BUCKET, 0.3f);
        this.kilnFurnaceRecipe(consumer, Registration.CLAY_BUCKET, Registration.CRACKED_CLAY_BUCKET, 0.2f);
        ShapedRecipeBuilder.func_200470_a(Registration.UNFIRED_CLAY_PLATE).func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_151119_aD).func_200472_a("cc").func_200465_a("has_clay", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151119_aD)).func_200464_a(consumer);
        this.kilnFurnaceRecipe(consumer, Registration.UNFIRED_CLAY_PLATE, Registration.CLAY_PLATE, 0.3f);
        InventoryChangeTrigger.Instance hasClayPlate = this.func_200403_a(Registration.CLAY_PLATE);
        ShapedRecipeBuilder.func_200470_a(Registration.CLAY_HELMET).func_200462_a(Character.valueOf('c'), Registration.CLAY_PLATE).func_200472_a("ccc").func_200472_a("c c").func_200465_a("has_plate", (ICriterionInstance)hasClayPlate).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(Registration.CLAY_CHESTPLATE).func_200462_a(Character.valueOf('c'), Registration.CLAY_PLATE).func_200472_a("c c").func_200472_a("ccc").func_200472_a("ccc").func_200465_a("has_plate", (ICriterionInstance)hasClayPlate).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(Registration.CLAY_LEGGINGS).func_200462_a(Character.valueOf('c'), Registration.CLAY_PLATE).func_200472_a("ccc").func_200472_a("c c").func_200472_a("c c").func_200465_a("has_plate", (ICriterionInstance)hasClayPlate).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(Registration.CLAY_BOOTS).func_200462_a(Character.valueOf('c'), Registration.CLAY_PLATE).func_200472_a("c c").func_200472_a("c c").func_200465_a("has_plate", (ICriterionInstance)hasClayPlate).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151119_aD, (int)4).func_200487_b((IItemProvider)Items.field_221776_cx).func_200483_a("has_unfired", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221776_cx)).func_200490_a(RecipeProvider.locationString("clay_uncrafting")).func_200485_a(consumer, RecipeProvider.location("clay_uncrafting"));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151119_aD, (int)3).func_200487_b(Registration.UNFIRED_CLAY_BUCKET).func_200483_a("has_unfired", (ICriterionInstance)this.func_200403_a(Registration.UNFIRED_CLAY_BUCKET)).func_200490_a(RecipeProvider.locationString("clay_uncrafting")).func_200485_a(consumer, RecipeProvider.suffix(Registration.UNFIRED_CLAY_BUCKET, "_uncrafting"));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151119_aD, (int)2).func_200487_b(Registration.UNFIRED_CLAY_PLATE).func_200483_a("has_unfired", (ICriterionInstance)this.func_200403_a(Registration.UNFIRED_CLAY_PLATE)).func_200490_a(RecipeProvider.locationString("clay_uncrafting")).func_200485_a(consumer, RecipeProvider.suffix(Registration.UNFIRED_CLAY_PLATE, "_uncrafting"));
        ShapelessRecipeBuilder.func_200488_a(Registration.UNFIRED_PORCELAIN, (int)4).func_200487_b(Registration.UNFIRED_PORCELAIN_BLOCK).func_200483_a("has_unfired", (ICriterionInstance)this.func_200403_a(Registration.UNFIRED_PORCELAIN_BLOCK)).func_200490_a(RecipeProvider.locationString("porcelain_uncrafting")).func_200485_a(consumer, RecipeProvider.suffix(Registration.UNFIRED_PORCELAIN_BLOCK, "_uncrafting"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150414_aQ).func_200469_a(Character.valueOf('M'), CeramicsTags.Items.MILK_BUCKETS).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151102_aT).func_200462_a(Character.valueOf('W'), (IItemProvider)Items.field_151015_O).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151110_aK).func_200472_a("MMM").func_200472_a("SES").func_200472_a("WWW").func_200465_a("has_egg", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151110_aK)).func_200467_a(consumer, RecipeProvider.location("cake"));
        ShapedRecipeBuilder.func_200470_a(Registration.KILN).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151118_aC).func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_221738_ce).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_221647_bL).func_200472_a("BBB").func_200472_a("BFB").func_200472_a("HHH").func_200465_a("has_brick", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151118_aC)).func_200464_a(consumer);
        this.kilnRecipe(consumer, (IItemProvider)Items.field_151119_aD, (IItemProvider)Items.field_151118_aC, 0.3f);
        this.kilnRecipe(consumer, (IItemProvider)Blocks.field_150435_aG, (IItemProvider)Blocks.field_150405_ch, 0.3f);
        this.eachEnum(Registration.TERRACOTTA, (Enum[])DyeColor.values(), (input, color) -> this.kilnRecipe(consumer, (IItemProvider)input, (IItemProvider)GLAZED_TERRACOTTA.get(color), 0.1f));
        this.kilnRecipe(consumer, (Tag<Item>)ItemTags.field_203440_u, (IItemProvider)Blocks.field_150359_w, 0.1f);
        this.kilnRecipe(consumer, (IItemProvider)Blocks.field_150322_A, (IItemProvider)Blocks.field_196580_bH, 0.1f);
        this.kilnRecipe(consumer, (IItemProvider)Blocks.field_180395_cM, (IItemProvider)Blocks.field_196582_bJ, 0.1f);
        this.kilnRecipe(consumer, (IItemProvider)Blocks.field_150347_e, (IItemProvider)Blocks.field_150348_b, 0.1f);
        this.kilnRecipe(consumer, (IItemProvider)Blocks.field_150348_b, (IItemProvider)Blocks.field_196579_bG, 0.1f);
        this.kilnRecipe(consumer, (IItemProvider)Blocks.field_196696_di, (IItemProvider)Blocks.field_196700_dk, 0.1f);
        this.kilnRecipe(consumer, (IItemProvider)Blocks.field_150424_aL, (IItemProvider)Items.field_196154_dH, 0.1f);
        this.kilnRecipe(consumer, (IItemProvider)Blocks.field_150371_ca, (IItemProvider)Blocks.field_196581_bI, 0.1f);
        this.kilnFurnaceRecipe(consumer, (IItemProvider)Blocks.field_196640_bx, (IItemProvider)Blocks.field_222452_lp, 0.1f);
        this.kilnFurnaceRecipe(consumer, (IItemProvider)Blocks.field_150372_bz, (IItemProvider)Blocks.field_222439_lc, 0.1f);
        this.kilnFurnaceRecipe(consumer, (IItemProvider)Blocks.field_196578_bE, (IItemProvider)Blocks.field_222447_lk, 0.1f);
        this.kilnFurnaceRecipe(consumer, (IItemProvider)Blocks.field_180396_cN, (IItemProvider)Blocks.field_222408_kW, 0.1f);
        this.kilnFurnaceRecipe(consumer, (IItemProvider)Blocks.field_196646_bz, (IItemProvider)Blocks.field_150333_U, 0.1f);
        this.kilnFurnaceRecipe(consumer, (IItemProvider)Blocks.field_196659_cl, (IItemProvider)Blocks.field_222438_lb, 0.1f);
        this.kilnFurnaceRecipe(consumer, (IItemProvider)Blocks.field_150333_U, (IItemProvider)Blocks.field_222401_hJ, 0.1f);
        this.kilnFurnaceRecipe(consumer, (IItemProvider)Blocks.field_150370_cb, (IItemProvider)Blocks.field_222440_ld, 0.1f);
    }

    private static ResourceLocation location(String id) {
        return new ResourceLocation("ceramics", id);
    }

    private static String locationString(String id) {
        return "ceramics:" + id;
    }

    private static ResourceLocation suffix(ResourceLocation loc, String suffix) {
        return new ResourceLocation(loc.func_110624_b(), loc.func_110623_a() + suffix);
    }

    private static ResourceLocation suffix(IItemProvider item, String suffix) {
        return RecipeProvider.suffix(item.func_199767_j().getRegistryName(), suffix);
    }

    private <T extends Enum<T>> void eachEnum(EnumBlockObject<T, ? extends Block> enumBlock, T[] values, BiConsumer<Item, T> consumer) {
        for (T value : values) {
            consumer.accept(enumBlock.asItem(value), (Item)value);
        }
    }

    private void eachBuilding(BuildingBlockObject input, BuildingBlockObject output, BiConsumer<Item, Item> consumer) {
        consumer.accept((Item)input.func_199767_j(), (Item)output.func_199767_j());
        consumer.accept((Item)input.getSlabItem(), (Item)output.getSlabItem());
        consumer.accept((Item)input.getStairsItem(), (Item)output.getStairsItem());
        consumer.accept((Item)input.getWallItem(), (Item)output.getWallItem());
    }

    private void registerSlabStairWall(@Nonnull Consumer<IFinishedRecipe> consumer, BuildingBlockObject building) {
        Object item = building.func_199767_j();
        ResourceLocation location = item.getRegistryName();
        InventoryChangeTrigger.Instance hasBuilding = this.func_200405_a(new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200308_a(item).func_200310_b()});
        Ingredient ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        BlockItem slab = building.getSlabItem();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)slab, (int)6).func_200462_a(Character.valueOf('B'), item).func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)hasBuilding).func_200473_b(slab.getRegistryName().toString()).func_200467_a(consumer, RecipeProvider.suffix(location, "_slab_crafting"));
        SingleItemRecipeBuilder.func_218644_a((Ingredient)ingredient, (IItemProvider)slab, (int)2).func_218643_a("has_item", (ICriterionInstance)hasBuilding).func_218647_a(consumer, RecipeProvider.suffix(location, "_slab_stonecutter"));
        BlockItem stairs = building.getStairsItem();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)stairs, (int)4).func_200462_a(Character.valueOf('B'), item).func_200472_a("B  ").func_200472_a("BB ").func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)hasBuilding).func_200473_b(stairs.getRegistryName().toString()).func_200467_a(consumer, RecipeProvider.suffix(location, "_stairs_crafting"));
        SingleItemRecipeBuilder.func_218648_a((Ingredient)ingredient, (IItemProvider)stairs).func_218643_a("has_item", (ICriterionInstance)hasBuilding).func_218647_a(consumer, RecipeProvider.suffix(location, "_stairs_stonecutter"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)building.getWallItem(), (int)6).func_200462_a(Character.valueOf('B'), item).func_200472_a("BBB").func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)hasBuilding).func_200467_a(consumer, RecipeProvider.suffix(location, "_wall_crafting"));
        SingleItemRecipeBuilder.func_218648_a((Ingredient)ingredient, (IItemProvider)building.getWallItem()).func_218643_a("has_item", (ICriterionInstance)hasBuilding).func_218647_a(consumer, RecipeProvider.suffix(location, "_wall_stonecutter"));
        ShapedRecipeBuilder.func_200470_a(item).func_200462_a(Character.valueOf('B'), (IItemProvider)slab).func_200472_a("B").func_200472_a("B").func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)slab)).func_200473_b(location.toString()).func_200467_a(consumer, RecipeProvider.suffix(location, "_from_slab"));
    }

    private void addBrickRecipe(@Nonnull Consumer<IFinishedRecipe> consumer, BuildingBlockObject from, Item ingredient, BuildingBlockObject to, String name) {
        InventoryChangeTrigger.Instance criteria = this.func_200403_a((IItemProvider)ingredient);
        this.eachBuilding(from, to, (arg_0, arg_1) -> RecipeProvider.lambda$addBrickRecipe$6(ingredient, name, (ICriterionInstance)criteria, consumer, arg_0, arg_1));
    }

    private static CookingRecipeBuilder kilnRecipe(Ingredient input, IItemProvider output, float experience, int cookTime) {
        return CookingRecipeBuilder.func_218631_a((Ingredient)input, (IItemProvider)output, (float)experience, (int)cookTime, (CookingRecipeSerializer)((CookingRecipeSerializer)Registration.KILN_SERIALIZER.get()));
    }

    private static void kilnRecipe(Consumer<IFinishedRecipe> consumer, Ingredient input, ICriterionInstance criteria, IItemProvider output, float experience, ResourceLocation name) {
        RecipeProvider.kilnRecipe(input, output, experience, 100).func_218628_a("has_item", criteria).func_218635_a(consumer, name);
    }

    private void kilnRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider input, IItemProvider output, float experience) {
        RecipeProvider.kilnRecipe(consumer, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (ICriterionInstance)this.func_200403_a(input), output, experience, RecipeProvider.location(output.func_199767_j().getRegistryName().func_110623_a() + "_kiln"));
    }

    private void kilnRecipe(Consumer<IFinishedRecipe> consumer, Tag<Item> input, IItemProvider output, float experience) {
        RecipeProvider.kilnRecipe(consumer, Ingredient.func_199805_a(input), (ICriterionInstance)this.func_200409_a(input), output, experience, RecipeProvider.location(output.func_199767_j().getRegistryName().func_110623_a() + "_kiln"));
    }

    private static void kilnFurnaceRecipe(Consumer<IFinishedRecipe> consumer, Ingredient input, ICriterionInstance criteria, IItemProvider output, float experience, ResourceLocation name) {
        CookingRecipeBuilder.func_218629_c((Ingredient)input, (IItemProvider)output, (float)experience, (int)200).func_218628_a("has_item", criteria).func_218635_a(consumer, RecipeProvider.suffix(name, "_smelting"));
        RecipeProvider.kilnRecipe(consumer, input, criteria, output, experience, RecipeProvider.suffix(name, "_kiln"));
    }

    private void kilnFurnaceRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider input, IItemProvider output, float experience, ResourceLocation name) {
        RecipeProvider.kilnFurnaceRecipe(consumer, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (ICriterionInstance)this.func_200403_a(input), output, experience, name);
    }

    private void kilnFurnaceRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider input, IItemProvider output, float experience) {
        this.kilnFurnaceRecipe(consumer, input, output, experience, RecipeProvider.location(output.func_199767_j().getRegistryName().func_110623_a()));
    }

    private void kilnFurnaceRecipe(Consumer<IFinishedRecipe> consumer, Tag<Item> input, IItemProvider output, float experience, ResourceLocation name) {
        RecipeProvider.kilnFurnaceRecipe(consumer, Ingredient.func_199805_a(input), (ICriterionInstance)this.func_200409_a(input), output, experience, name);
    }

    private void kilnFurnaceRecipe(Consumer<IFinishedRecipe> consumer, Tag<Item> input, IItemProvider output, float experience) {
        this.kilnFurnaceRecipe(consumer, input, output, experience, RecipeProvider.location(output.func_199767_j().getRegistryName().func_110623_a()));
    }

    private static /* synthetic */ void lambda$addBrickRecipe$6(Item ingredient, String name, ICriterionInstance criteria, @Nonnull Consumer consumer, Item input, Item output) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)output, (int)8).func_200462_a(Character.valueOf('B'), (IItemProvider)input).func_200462_a(Character.valueOf('i'), (IItemProvider)ingredient).func_200472_a("BBB").func_200472_a("BiB").func_200472_a("BBB").func_200465_a("has_" + name, criteria).func_200473_b(output.getRegistryName().toString()).func_200467_a(consumer, RecipeProvider.suffix((IItemProvider)output, "_" + name));
    }

    private static /* synthetic */ void lambda$registerRecipes$2(ICriterionInstance hasTheRainbow, @Nonnull Consumer consumer, Item item, RainbowPorcelain color) {
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199805_a(CeramicsTags.Items.RAINBOW_PORCELAIN), (IItemProvider)item).func_218643_a("has_the_rainbow", hasTheRainbow).func_218647_a(consumer, item.getRegistryName());
    }

    private static /* synthetic */ void lambda$registerRecipes$1(ICriterionInstance porcelainCriteria, @Nonnull Consumer consumer, Item item, DyeColor color) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)item, (int)8).func_200469_a(Character.valueOf('B'), CeramicsTags.Items.PORCELAIN).func_200469_a(Character.valueOf('D'), color.getTag()).func_200473_b(RecipeProvider.locationString("dye_porcelain")).func_200472_a("BBB").func_200472_a("BDB").func_200472_a("BBB").func_200465_a("has_porcelain", porcelainCriteria).func_200464_a(consumer);
    }

    private static /* synthetic */ void lambda$registerRecipes$0(ICriterionInstance terracottaCriteria, @Nonnull Consumer consumer, Item item, DyeColor color) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)item, (int)8).func_200469_a(Character.valueOf('B'), CeramicsTags.Items.COLORED_TERRACOTTA).func_200469_a(Character.valueOf('D'), color.getTag()).func_200473_b("stained_terracotta").func_200472_a("BBB").func_200472_a("BDB").func_200472_a("BBB").func_200465_a("has_terracotta", terracottaCriteria).func_200467_a(consumer, RecipeProvider.location(item.getRegistryName().func_110623_a() + "_recolor"));
    }

    static {
        EnumMap<DyeColor, Block> map = new EnumMap<DyeColor, Block>(DyeColor.class);
        map.put(DyeColor.WHITE, Blocks.field_192427_dB);
        map.put(DyeColor.ORANGE, Blocks.field_192428_dC);
        map.put(DyeColor.MAGENTA, Blocks.field_192429_dD);
        map.put(DyeColor.LIGHT_BLUE, Blocks.field_192430_dE);
        map.put(DyeColor.YELLOW, Blocks.field_192431_dF);
        map.put(DyeColor.LIME, Blocks.field_192432_dG);
        map.put(DyeColor.PINK, Blocks.field_192433_dH);
        map.put(DyeColor.GRAY, Blocks.field_192434_dI);
        map.put(DyeColor.LIGHT_GRAY, Blocks.field_196876_iu);
        map.put(DyeColor.CYAN, Blocks.field_192436_dK);
        map.put(DyeColor.PURPLE, Blocks.field_192437_dL);
        map.put(DyeColor.BLUE, Blocks.field_192438_dM);
        map.put(DyeColor.BROWN, Blocks.field_192439_dN);
        map.put(DyeColor.GREEN, Blocks.field_192440_dO);
        map.put(DyeColor.RED, Blocks.field_192441_dP);
        map.put(DyeColor.BLACK, Blocks.field_192442_dQ);
        GLAZED_TERRACOTTA = map;
    }

    private static class NBTIngredient
    extends net.minecraftforge.common.crafting.NBTIngredient {
        protected NBTIngredient(ItemStack stack) {
            super(stack);
        }
    }
}

