/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.datagen;

import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import knightminer.ceramics.Registration;
import knightminer.ceramics.blocks.RainbowPorcelain;
import knightminer.ceramics.registration.BuildingBlockObject;
import knightminer.ceramics.registration.EnumBlockObject;
import net.minecraft.block.Block;
import net.minecraft.item.DyeColor;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockLootTables
extends net.minecraft.data.loot.BlockLootTables {
    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "ceramics".equals(block.getRegistryName().func_110624_b())).collect(Collectors.toList());
    }

    protected void addTables() {
        this.func_218522_a(Registration.UNFIRED_PORCELAIN_BLOCK.get(), block -> BlockLootTables.func_218530_a((Block)block, Registration.UNFIRED_PORCELAIN, (IRandomRange)ConstantRange.func_215835_a((int)4)));
        this.registerEnumLootTables(Registration.PORCELAIN_BLOCK, (Enum[])DyeColor.values());
        this.registerEnumLootTables(Registration.RAINBOW_PORCELAIN, RainbowPorcelain.values());
        this.registerBuildingLootTable(Registration.DARK_BRICKS);
        this.registerBuildingLootTable(Registration.LAVA_BRICKS);
        this.registerBuildingLootTable(Registration.DRAGON_BRICKS);
        this.registerBuildingLootTable(Registration.PORCELAIN_BRICKS);
        this.registerBuildingLootTable(Registration.MONOCHROME_BRICKS);
        this.registerBuildingLootTable(Registration.GOLDEN_BRICKS);
        this.registerBuildingLootTable(Registration.MARINE_BRICKS);
        this.registerBuildingLootTable(Registration.RAINBOW_BRICKS);
        this.func_218492_c((Block)Registration.KILN.get());
    }

    private <T extends Enum<T>> void registerEnumLootTables(EnumBlockObject<T, ? extends Block> enumBlock, T[] values) {
        for (T value : values) {
            this.func_218492_c(enumBlock.getBlock(value));
        }
    }

    private void registerBuildingLootTable(BuildingBlockObject building) {
        this.func_218492_c((Block)building.get());
        this.func_218492_c((Block)building.getSlab());
        this.func_218492_c((Block)building.getStairs());
        this.func_218492_c((Block)building.getWall());
    }
}

