/*
 * Decompiled with CFR 0.152.
 */
package net.olafkeijsers.fastleafdecay;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class FldScheduler {
    public static FldScheduler INSTANCE = new FldScheduler();
    List<BlockUpdate> plannedUpdates = new ArrayList<BlockUpdate>();
    List<BlockUpdate> scheduledUpdates = new ArrayList<BlockUpdate>();

    public void schedule(World world, BlockPos pos, int delay) {
        if (world instanceof ServerWorld) {
            this.plannedUpdates.add(new BlockUpdate(world, pos, delay));
        }
    }

    public void tick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            if (!this.plannedUpdates.isEmpty()) {
                this.scheduledUpdates.addAll(this.plannedUpdates);
                this.plannedUpdates.clear();
            }
            Iterator<BlockUpdate> iterator = this.scheduledUpdates.iterator();
            while (iterator.hasNext()) {
                BlockState state;
                BlockUpdate scheduledUpdate = iterator.next();
                --scheduledUpdate.tick;
                if (scheduledUpdate.tick > 0) continue;
                iterator.remove();
                World worldObj = (World)scheduledUpdate.worldReference.get();
                if (worldObj == null || !worldObj.func_175667_e(scheduledUpdate.pos) || !BlockTags.field_206952_E.func_199685_a_((Object)(state = worldObj.func_180495_p(scheduledUpdate.pos)).func_177230_c())) continue;
                state.func_227033_a_((ServerWorld)worldObj, scheduledUpdate.pos, worldObj.func_201674_k());
                state.func_227034_b_((ServerWorld)worldObj, scheduledUpdate.pos, worldObj.func_201674_k());
            }
        }
    }

    class BlockUpdate {
        WeakReference<World> worldReference;
        BlockPos pos;
        int tick;

        public BlockUpdate(World worldObj, BlockPos pos, int tick) {
            this.worldReference = new WeakReference<World>(worldObj);
            this.pos = pos;
            this.tick = tick;
        }
    }
}

