/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.supermartijn642.connectedglass.data.CGBlockLootTables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.ValidationTracker;

public class CGLootTableProvider
extends LootTableProvider {
    public CGLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(CGBlockLootTables::new, (Object)LootParameterSets.field_216267_h));
    }

    protected void validate(Map<ResourceLocation, LootTable> lootTables, ValidationTracker validationtracker) {
        Set locations = LootTables.func_215796_a().stream().filter(resourceLocation -> resourceLocation.func_110624_b().equals("connectedglass")).collect(Collectors.toSet());
        for (ResourceLocation resourcelocation : Sets.difference(locations, lootTables.keySet())) {
            validationtracker.func_227530_a_("Missing built-in table: " + resourcelocation);
        }
        lootTables.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
    }

    public String func_200397_b() {
        return "connectedglass:loottables";
    }
}

