/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGColoredGlassBlock;
import com.supermartijn642.connectedglass.CGColoredPaneBlock;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.ConnectedGlass;
import com.supermartijn642.connectedglass.model.CGBakedModel;
import com.supermartijn642.connectedglass.model.CGConnectedBakedModel;
import com.supermartijn642.connectedglass.model.CGConnectedPaneBakedModel;
import com.supermartijn642.connectedglass.model.CGPaneBakedModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    public static final Map<CGGlassBlock, TextureAtlasSprite> TEXTURES = new HashMap<CGGlassBlock, TextureAtlasSprite>();

    @SubscribeEvent
    public static void onBake(ModelBakeEvent e) {
        Object model;
        for (CGGlassBlock block : ConnectedGlass.BLOCKS) {
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)(block instanceof CGColoredGlassBlock ? RenderType.func_228645_f_() : RenderType.func_228643_e_()));
            model = block.connected ? new CGConnectedBakedModel(block) : new CGBakedModel(block);
            e.getModelRegistry().put(new ModelResourceLocation(block.getRegistryName(), ""), model);
            e.getModelRegistry().put(new ModelResourceLocation(block.getRegistryName(), "inventory"), model);
        }
        Iterator<Object> iterator = ConnectedGlass.PANES.iterator();
        while (iterator.hasNext()) {
            CGPaneBlock pane;
            RenderTypeLookup.setRenderLayer((Block)pane, (RenderType)((pane = (CGPaneBlock)((Object)iterator.next())) instanceof CGColoredPaneBlock ? RenderType.func_228645_f_() : RenderType.func_228641_d_()));
            model = pane.block.connected ? new CGConnectedPaneBakedModel(pane) : new CGPaneBakedModel(pane);
            e.getModelRegistry().put(new ModelResourceLocation(pane.getRegistryName(), "inventory"), model);
            pane.func_176194_O().func_177619_a().forEach(arg_0 -> ClientProxy.lambda$onBake$0(e, pane, (CGPaneBakedModel)model, arg_0));
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre e) {
        if (e.getMap().func_229223_g_().toString().equals("minecraft:textures/atlas/blocks.png")) {
            for (CGGlassBlock block : ConnectedGlass.BLOCKS) {
                e.addSprite(block.getRegistryName());
            }
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Post e) {
        if (e.getMap().func_229223_g_().toString().equals("minecraft:textures/atlas/blocks.png")) {
            for (CGGlassBlock block : ConnectedGlass.BLOCKS) {
                TEXTURES.put(block, e.getMap().func_195424_a(block.getRegistryName()));
            }
        }
    }

    private static /* synthetic */ void lambda$onBake$0(ModelBakeEvent e, CGPaneBlock pane, CGPaneBakedModel model, BlockState state) {
        String variant = state.toString();
        variant = variant.indexOf(91) > 0 ? variant.substring(variant.indexOf(91) + 1, variant.length() - 1) : "";
        e.getModelRegistry().put(new ModelResourceLocation(pane.getRegistryName(), variant), model);
    }
}

