// priority: 1
events.listen('recipes', function (event) {
  event.remove({ input: 'silents_mechanisms:uranium_ore', exact: true })
  event.remove({ input: 'silents_mechanisms:copper_ore', exact: true })
  event.remove({ input: 'silents_mechanisms:tin_ore', exact: true })
  event.remove({ output: 'miscadditions:cobalt' })
  event.remove({ output: 'miscadditions:cobalt_clump' })
  event.remove({ output: 'miscadditions:cobalt_ingot' })
  event.remove({ output: 'miscadditions:cobalt_sword' })
  event.remove({ output: 'miscadditions:cobalt_shovel' })
  event.remove({ output: 'miscadditions:cobalt_pickaxe' })
  event.remove({ output: 'miscadditions:cobalt_axe' })
  event.remove({ output: 'miscadditions:cobalt_hoe' })
  event.remove({ output: 'mekanism:upgrade_anchor' })

  event.replaceOutput('#forge:dusts/coal', 'wtbw_machines:coal_dust')
  event.replaceOutput('#forge:dusts/charcoal', 'wtbw_machines:charcoal_dust')

  var unifyMetal = function (name, ingotItem, dustItem, blockItem, nuggetItem) {
    event.replaceOutput('#forge:ingots/' + name, ingotItem)
    event.replaceOutput('#forge:dusts/' + name, dustItem)
    event.replaceOutput('#forge:nuggets/' + name, nuggetItem)
    event.replaceOutput('#forge:storage_blocks/' + name, blockItem)
    event.remove({ output: '#forge:ingots/' + name, type: 'minecraft:smelting' })
    event.remove({ output: '#forge:ingots/' + name, type: 'minecraft:blasting' })
    event.recipes.minecraft.smelting(ingotItem, '#forge:dusts/' + name)
    event.recipes.minecraft.smelting(ingotItem, '#forge:ores/' + name)
    event.recipes.minecraft.blasting(ingotItem, '#forge:dusts/' + name)
    event.recipes.minecraft.blasting(ingotItem, '#forge:ores/' + name)
  }

  unifyMetal('iron', 'minecraft:iron_ingot', 'wtbw_machines:iron_dust', 'minecraft:iron_block', 'minecraft:iron_nugget')
  unifyMetal('gold', 'minecraft:gold_ingot', 'wtbw_machines:gold_dust', 'minecraft:gold_block', 'minecraft:gold_nugget')
  unifyMetal('copper', 'wtbw_core:copper_ingot', 'wtbw_machines:copper_dust', 'wtbw_core:copper_block', 'mekanism:nugget_copper')
  unifyMetal('tin', 'mekanism:ingot_tin', 'mekanism:dust_tin', 'mekanism:block_tin', 'mekanism:nugget_tin')
  unifyMetal('steel', 'mekanism:ingot_steel', 'mekanism:dust_steel', 'mekanism:block_steel', 'mekanism:nugget_steel')

  event.replaceInput('xlfoodmod:salt', '#forge:dusts/salt')

  event.remove({ input: 'silents_mechanisms:gold_chunks', exact: true})
  event.remove({ input: 'silents_mechanisms:iron_chunks', exact: true })
  event.remove({ input: 'silents_mechanisms:copper_chunks', exact: true })
  event.remove({ input: 'silents_mechanisms:tin_chunks', exact: true })
})

events.listen('item.tags', function (event) {
  event.get('forge:ores/coal').add('goodnightsleep:coal_ore')
  event.get('forge:ores/lapis').add('goodnightsleep:lapis_ore')
  event.get('forge:plates/iron').add('mcwbridges:iron_platform')
  event.get('forge:plates').add('mcwbridges:iron_platform')
  event.get('forge:dusts/salt').add('xlfoodmod:salt')

  event.get('forge:ores/tin').remove('silents_mechanisms:tin_ore')
  event.get('forge:ores/copper').remove('silents_mechanisms:copper_ore')
})

events.listen('block.tags', function (event) {
  event.get('forge:ores/coal').add('goodnightsleep:coal_ore')
  event.get('forge:ores/lapis').add('goodnightsleep:lapis_ore')
  event.get('forge:ores/tin').remove('silents_mechanisms:tin_ore')
  event.get('forge:ores/copper').remove('silents_mechanisms:copper_ore')
})
