// priority: 0
events.listen('recipes', function (e) {
    e.remove({ id: 'wtbw_core:shortcut/bread' })
    e.remove({ id: 'wtbw_core:shortcut/stick' })

    e.remove({ id: 'silents_mechanisms:compressing/blaze_rod' })
    e.recipes.silents_mechanisms.compressing({
        process_time: 400,
        ingredient: {
            item: 'minecraft:blaze_powder',
            count: 4
        },
            result: {
                item: 'minecraft:blaze_rod'
            }
    })

    e.remove({ id: 'cfm:birch_upgraded_fence' })
    e.remove({ id: 'cfm:jungle_upgraded_fence' })
    e.remove({ id: 'cfm:dark_oak_upgraded_fence' })
    e.remove({ id: 'cfm:oak_upgraded_fence' })
    e.remove({ id: 'cfm:spruce_upgraded_fence' })

    e.shapeless(item.of('cfm:birch_upgraded_fence', 1), ['minecraft:birch_fence'])
    e.shapeless(item.of('cfm:jungle_upgraded_fence', 1), ['minecraft:jungle_fence'])
    e.shapeless(item.of('cfm:dark_oak_upgraded_fence', 1), ['minecraft:dark_oak_fence'])
    e.shapeless(item.of('cfm:oak_upgraded_fence', 1), ['minecraft:oak_fence'])
    e.shapeless(item.of('cfm:spruce_upgraded_fence', 1), ['minecraft:spruce_fence'])

    e.shapeless(item.of('minecraft:birch_fence', 1), ['cfm:birch_upgraded_fence'])
    e.shapeless(item.of('minecraft:jungle_fence', 1), ['cfm:jungle_upgraded_fence'])
    e.shapeless(item.of('minecraft:dark_oak_fence', 1), ['cfm:dark_oak_upgraded_fence'])
    e.shapeless(item.of('minecraft:oak_fence', 1), ['cfm:oak_upgraded_fence'])
    e.shapeless(item.of('minecraft:spruce_fence', 1), ['cfm:spruce_upgraded_fence'])

    e.shaped(item.of('minecraft:stick', 16), [
        'S',
        'S'
    ], {
        S: [
            'minecraft:oak_log',
            'minecraft:spruce_log',
            'minecraft:birch_log',
            'minecraft:acacia_log',
            'minecraft:dark_oak_log',
            'biomesoplenty:fir_log',
            'biomesoplenty:redwood_log',
            'biomesoplenty:cherry_log',
            'biomesoplenty:mahogany_log',
            'biomesoplenty:jacaranda_log',
            'biomesoplenty:palm_log',
            'biomesoplenty:willow_log',
            'biomesoplenty:dead_log',
            'biomesoplenty:magic_log',
            'biomesoplenty:umbran_log',
            'biomesoplenty:hellbark_log',
            'goodnightsleep:dream_log',
            'goodnightsleep:white_log',
            'goodnightsleep:dead_log',
            'goodnightsleep:blood_log',
            'miscadditions:mangrove_log',
            'miscadditions:charred_log',
            'naturesaura:ancient_log',
            'rats:pirat_log'
        ]
    })
    e.shaped(item.of('animalcrops:pollen', 4), [
        'bcd',
        'eaf',
        'ghi'
    ], {
        a: 'minecraft:wheat_seeds',
        b: 'minecraft:potato',
        c: 'minecraft:grass',
        d: 'minecraft:apple',
        e: 'minecraft:porkchop',
        f: 'minecraft:beef',
        g: 'minecraft:mutton',
        h: 'minecraft:carrot',
        i: 'minecraft:melon_slice'

    })

    var crushingSilents = function (tag, iCount, result, rCount, duration) {
    e.recipes.silents_mechanisms.crushing({
      process_time: duration,
      ingredient: {
        tag: tag
      },
      results: [
        {
          item: result,
          count: rCount
        }
      ]
    })
    }

    var crushingSilentsItem = function (item, iCount, result, rCount, duration) {
    e.recipes.silents_mechanisms.crushing({
      process_time: duration,
      ingredient: {
        item: item
      },
      results: [
        {
          item: result,
          count: rCount
        }
      ]
    })
    }

    var crushingSilents2 = function (tag, result, rCount, result1, rCount1, rChance1, duration) {
    e.recipes.silents_mechanisms.crushing({
      process_time: duration,
      ingredient: {
        tag: tag
      },
      results: [
        {
          item: result,
          count: rCount
        },
        {
          item: result1,
          count: rCount1,
          chance: rChance1
        }
      ]
    })
    }

    var crushingSilents2Item = function (item, result, rCount, result1, rCount1, rChance1, duration) {
    e.recipes.silents_mechanisms.crushing({
      process_time: duration,
      ingredient: {
        item: item
      },
      results: [
        {
          item: result,
          count: rCount
        },
        {
          item: result1,
          count: rCount1,
          chance: rChance1
        }
      ]
    })
    }

    var crushingWTBW = function (tag, iCount, result, rCount, duration, power_cost) {
    e.recipes.wtbw_machines.crushing({
      ingredient: {
        tag: tag,
        count: iCount
      },
      result: [
        {
          item: result,
          count: rCount
        }
      ],
      duration: duration,
      power_cost: power_cost
    })
    }

    var crushingWTBWItem = function (item, iCount, result, rCount, duration, power_cost) {
    e.recipes.wtbw_machines.crushing({
      ingredient: {
        item: item,
        count: iCount
      },
      result: [
        {
          item: result,
          count: rCount
        }
      ],
      duration: duration,
      power_cost: power_cost
    })
    }

    var crushingWTBW2 = function (tag, iCount, result, rCount, result1, rCount1, rChance1, duration, power_cost) {
    e.recipes.wtbw_machines.crushing({
      ingredient: {
        tag: tag,
        count: iCount
      },
      result: [
        {
          item: result,
          count: rCount
        },
        {
          item: result1,
          count: rCount1,
          chance: rChance1
        }
      ],
      duration: duration,
      power_cost: power_cost
    })
    }

    var crushingWTBW2Item = function (item, iCount, result, rCount, result1, rCount1, rChance1, duration, power_cost) {
    e.recipes.wtbw_machines.crushing({
      ingredient: {
        item: item,
        count: iCount
      },
      result: [
        {
          item: result,
          count: rCount
        },
        {
          item: result1,
          count: rCount1,
          chance: rChance1
        }
      ],
      duration: duration,
      power_cost: power_cost
    })
    }

    var enriching = function (tag, result, rCount) {
    e.recipes.mekanism.enriching({
      input: {
        ingredient: {
          tag: tag
        }
      },
      output: {
        item: result,
        count: rCount
      }
    })
    }

    var enrichingItem = function (item, result, rCount) {
        e.recipes.mekanism.enriching({
            input: {
                ingredient: {
                    item: item
                }
            },
            output: {
                item: result,
                count: rCount
            }
        })
    }

    crushingWTBW2(
        'forge:ores/aluminum',
        1,
        'silents_mechanisms:bauxite_chunks',
        2,
        'minecraft:cobblestone',
        1,
        0.1,
        180,
        2500
    )
    crushingWTBW2('forge:ores/tin', 1, 'mekanism:dust_tin', 2, 'minecraft:cobblestone', 1, 0.1, 180, 2500)
    crushingWTBW2(
        'forge:ores/silver',
        1,
        'silents_mechanisms:silver_chunks',
        2,
        'minecraft:cobblestone',
        1,
        0.1,
        180,
        2500
    )
    crushingWTBW2('forge:ores/lead', 1, 'silents_mechanisms:lead_chunks', 2, 'minecraft:cobblestone', 1, 0.1, 180, 2500)
    crushingWTBW2(
        'forge:ores/nickel',
        1,
        'silents_mechanisms:nickel_chunks',
        2,
        'minecraft:cobblestone',
        1,
        0.1,
        180,
        2500
    )
    crushingWTBW2(
        'forge:ores/platinum',
        1,
        'silents_mechanisms:platinum_chunks',
        2,
        'minecraft:cobblestone',
        1,
        0.1,
        180,
        2500
    )
    crushingWTBW2('forge:ores/zinc', 1, 'silents_mechanisms:zinc_chunks', 2, 'minecraft:cobblestone', 1, 0.1, 180, 2500)
    crushingWTBW2(
        'forge:ores/bismuth',
        1,
        'silents_mechanisms:bismuth_chunks',
        2,
        'minecraft:cobblestone',
        1,
        0.1,
        180,
        2500
    )
    crushingWTBW2(
        'forge:ores/uranium',
        1,
        'silents_mechanisms:uranium_chunks',
        2,
        'minecraft:cobblestone',
        1,
        0.1,
        180,
        2500
    )

    crushingWTBW('forge:ores/osmium', 1, 'mekanism:dust_osmium', 2, 180, 2500)
    crushingSilents('forge:ores/osmium', 1, 'mekanism:dust_osmium', 2, 180)

    crushingWTBWItem('goodnightsleep:positite_ore', 1, 'goodnightsleep:positite_gem', 2, 180, 2500)
    crushingWTBWItem('goodnightsleep:negatite_ore', 1, 'goodnightsleep:negatite_gem', 2, 180, 2500)
    crushingSilentsItem('goodnightsleep:negatite_ore', 1, 'goodnightsleep:negatite_gem', 2, 180)
    crushingSilentsItem('goodnightsleep:positite_ore', 1, 'goodnightsleep:positite_gem', 2, 180)

    enriching('forge:ores/aluminum', 'silents_mechanisms:bauxite_chunks', 2)
    enriching('forge:ores/silver', 'silents_mechanisms:silver_chunks', 2)
    enriching('forge:ores/lead', 'silents_mechanisms:lead_chunks', 2)
    enriching('forge:ores/nickel', 'silents_mechanisms:nickel_chunks', 2)
    enriching('forge:ores/platinum', 'silents_mechanisms:platinum_chunks', 2)
    enriching('forge:ores/zinc', 'silents_mechanisms:zinc_chunks', 2)
    enriching('forge:ores/bismuth', 'silents_mechanisms:bismuth_chunks', 2)
    enriching('forge:ores/uranium', 'silents_mechanisms:uranium_chunks', 2)
    enrichingItem('goodnightsleep:positite_ore', 'goodnightsleep:positite_gem', 2)
    enrichingItem('goodnightsleep:negatite_ore', 'goodnightsleep:negatite_gem', 2)

    crushingWTBWItem('minecraft:prismarine', 1, 'minecraft:prismarine_shard', 4, 180, 2500)
    crushingWTBWItem('minecraft:prismarine_bricks', 1,'minecraft:prismarine_shard', 9, 180, 2500)
    crushingWTBW2Item('minecraft:dark_prismarine', 1, 'minecraft:prismarine_shard', 8, 'minecraft:black_dye', 1, 0.5, 180 , 2500)

    crushingSilentsItem('minecraft:prismarine', 1,'minecraft:prismarine_shard', 4, 180)
    crushingSilentsItem('minecraft:prismarine_bricks', 1, 'minecraft:prismarine_shard', 9, 180)
    crushingSilents2Item('minecraft:dark_prismarine', 'minecraft:prismarine_shard', 8, 'minecraft:black_dye', 1, 0.5, 180)

    e.recipes.mekanism.crushing(item.of('minecraft:prismarine_shard', 4), 'minecraft:prismarine')
    e.recipes.mekanism.crushing(item.of('minecraft:prismarine_shard', 9), 'minecraft:prismarine_bricks')
    e.recipes.mekanism.crushing(item.of('minecraft:prismarine_shard', 8), 'minecraft:dark_prismarine')

    enriching('forge:ores/cobalt', 'wtbw_machines:cobalt_dust', 2)
    crushingSilents('forge:ores/cobalt', 1,'wtbw_machines:cobalt_dust', 2, 180)

    e.remove({ output: 'soulshards:vile_dust' })
    crushingSilentsItem('minecraft:soul_sand', 1,'soulshards:vile_dust', 1, 180)
    crushingWTBWItem('minecraft:soul_sand', 1, 'soulshards:vile_dust', 1, 180, 2500)
    e.recipes.mekanism.crushing(item.of('soulshards:vile_dust', 1), 'minecraft:soul_sand')

    crushingWTBW2Item('silents_mechanisms:silver_chunks', 1, 'silents_mechanisms:silver_dust',1,'silents_mechanisms:silver_dust',1, 0.1, 180,2500)
    crushingWTBW2Item('silents_mechanisms:lead_chunks', 1, 'silents_mechanisms:lead_dust',1,'silents_mechanisms:lead_dust',1, 0.1, 180,2500)
    crushingWTBW2Item('silents_mechanisms:nickel_chunks', 1, 'silents_mechanisms:nickel_dust',1,'silents_mechanisms:nickel_dust',1, 0.1, 180,2500)
    crushingWTBW2Item('silents_mechanisms:platinum_chunks', 1, 'silents_mechanisms:platinum_dust',1,'silents_mechanisms:platinum_dust',1, 0.1, 180,2500)
    crushingWTBW2Item('silents_mechanisms:zinc_chunks', 1, 'silents_mechanisms:zinc_dust',1,'silents_mechanisms:zinc_dust',1, 0.1, 180,2500)
    crushingWTBW2Item('silents_mechanisms:bismuth_chunks', 1, 'silents_mechanisms:bismuth_dust',1,'silents_mechanisms:bismuth_dust',1, 0.1, 180,2500)
    crushingWTBW2Item('silents_mechanisms:bauxite_chunks', 1, 'silents_mechanisms:aluminum_dust',1,'silents_mechanisms:aluminum_dust',1, 0.1, 180,2500)
    crushingWTBW2Item('silents_mechanisms:uranium_chunks', 1, 'silents_mechanisms:uranium_dust',1,'silents_mechanisms:uranium_dust',1, 0.1, 180,2500)

    e.recipes.mekanism.crushing(item.of('silents_mechanisms:silver_dust', 1), 'silents_mechanisms:silver_chunks')
    e.recipes.mekanism.crushing(item.of('silents_mechanisms:lead_dust', 1), 'silents_mechanisms:lead_chunks')
    e.recipes.mekanism.crushing(item.of('silents_mechanisms:nickel_dust', 1), 'silents_mechanisms:nickel_chunks')
    e.recipes.mekanism.crushing(item.of('silents_mechanisms:platinum_dust', 1), 'silents_mechanisms:platinum_chunks')
    e.recipes.mekanism.crushing(item.of('silents_mechanisms:zinc_dust', 1), 'silents_mechanisms:zinc_chunks')
    e.recipes.mekanism.crushing(item.of('silents_mechanisms:bismuth_dust', 1), 'silents_mechanisms:bismuth_chunks')
    e.recipes.mekanism.crushing(item.of('silents_mechanisms:aluminum_dust', 1), 'silents_mechanisms:bauxite_chunks')
    e.recipes.mekanism.crushing(item.of('silents_mechanisms:uranium_dust', 1), 'silents_mechanisms:uranium_chunks')

    e.recipes.minecraft.blasting(item.of('powah:uraninite', 1), 'silents_mechanisms:uranium_ingot')
    e.recipes.minecraft.smoking(item.of('powah:uraninite', 1), 'silents_mechanisms:uranium_ingot')

    e.remove({ output: 'wtbw_machines:copper_drill' })
    e.remove({ output: 'wtbw_machines:diamond_drill' })
    e.remove({ output: 'wtbw_machines:iron_drill' })
    e.remove({ output: 'wtbw_machines:gold_drill' })
    e.remove({ output: 'wtbw_machines:cobalt_drill' })
    e.remove({ id: 'wtbw_machines:mining/iron_drill' })
    e.remove({ id: 'wtbw_machines:mining/gold_drill' })
    e.remove({ id: 'wtbw_machines:mining/diamond_drill' })
    e.remove({ id: 'wtbw_machines:mining/copper_drill' })
    e.remove({ id: 'wtbw_machines:mining/cobalt_drill' })
})
